/* Data */
(function(window){
	
	var FWDVUGPData = function(props, parent){
		
		var self = this;
		var prototype = FWDVUGPData.prototype;
		
		this.props_obj = props;
		this.rootElement_el = null;
		this.graphicsPaths_ar = [];
		this.skinPaths_ar = [];
		this.playlist_ar = [];
		this.lightboxPlaylist_ar = [];
		this.categories_ar = [];
		this.parsedPlaylist_ar = [];
		this.youtubeData_ar;
		
		this.backgroundColor_str;
		this.thumbnailOverlayBackgroundColor_str;
		this.lightBoxInfoWindowBackgroundColor_str;
		this.lightBoxItemBorderColor_str;
		this.lightBoxItemBackgroundColor_str;
		this.grabIconPath_str;
		this.handIconPath_str;
		this.imageIconPath_str;
		this.videoIconPath_str;
		this.linkIconPath_str;
		this.mainFolderPath_str;
		this.gridSkinPath_str;
		this.rightClickContextMenu_str;
		this.selectLabel_str;
		this.allCategoriesLabel_str;
		this.accessToken_str;
		this.scClientId_str = "0aff03b3b79c2ac02fd2283b300735bd";
		
		this.totalPlaylists;
		this.startAtCategory;
		this.thumbnailMaxWidth;
		this.thumbnailMaxHeight;
		this.thumbnailOverlayOpacity;
		this.countLoadedGraphics = 0;
		this.totalGraphics;
		this.totalItems;
		this.lightBoxInfoWindowBackgroundOpacity;
		this.lightBoxBackgroundOpacity;
		this.lightBoxBorderSize;
		this.lightBoxSlideShowDelay;
		this.countLoadedSkinImages = 0;
		this.youtubeLoadId = 0;
		this.nextPageToken_str = 0;
		
		
		this.parseDelayId_to;
		this.loadImageId_to;
		
		this.isYoutube_bl;
		this.showLightBoxZoomButton_bl;
		this.showLightBoxInfoButton_bl;
		this.showLighBoxSlideShowButton_bl;
		this.addLightBoxKeyboardSupport_bl;
		this.showLighBoxNextAndPrevButtons_bl;
		this.showContextMenu_bl;
		this.disableThumbnailsInteractivity_bl;
		this.isPlaylistDispatchingError_bl;
		
		
		this.isMobile_bl = FWDVRLUtils.isMobile;
		this.showHelpScreen_bl;;
		
		//###################################//
		/*init*/
		//###################################//
		this.init = function(){
			self.parseProperties();
		};
		
		this.parseProperties = function(){
			var errorMessage_str;
			var mediaKid;
		
			self.mainFolderPath_str = self.props_obj.mainFolderPath;
			if(!self.mainFolderPath_str){
				setTimeout(function(){
					if(self == null) return;
					errorMessage_str = "The <font color='#FF0000'>mainFolderPath</font> property is not defined in the constructor function!";
					self.dispatchEvent(FWDVRLData.LOAD_ERROR, {text:errorMessage_str});
				}, 50);
				return;
			}
			
			if((self.mainFolderPath_str.lastIndexOf("/") + 1) != self.mainFolderPath_str.length){
				self.mainFolderPath_str += "/";
			}
			
			self.gridSkinPath_str = self.props_obj.gridSkinPath;
			if(!self.gridSkinPath_str){
				setTimeout(function(){
					if(self == null) return;
					errorMessage_str = "The <font color='#FF0000'>gridSkinPath</font> property is not defined in the constructor function!";
					self.dispatchEvent(FWDVRLData.LOAD_ERROR, {text:errorMessage_str});
				}, 50);
				return;
			}
			
		
			if((self.gridSkinPath_str.lastIndexOf("/") + 1) != self.gridSkinPath_str.length){
				self.gridSkinPath_str += "/";
			}
			self.gridSkinPath_str = self.mainFolderPath_str + self.gridSkinPath_str;
			
			self.lightboxSkinPath_str = self.props_obj.lightboxSkinPath;
			if(!self.gridSkinPath_str){
				setTimeout(function(){
					if(self == null) return;
					errorMessage_str = "The <font color='#FF0000'>lightboxSkinPath</font> property is not defined in the constructor function!";
					self.dispatchEvent(FWDVRLData.LOAD_ERROR, {text:errorMessage_str});
				}, 50);
				return;
			}
			
			
			//###############################//
			/* set main properties */
			//###############################//
			self.rightClickContextMenu_str = self.props_obj.rightClickContextMenu || "developer";
			test = self.rightClickContextMenu_str == "developer" 
				   || self.rightClickContextMenu_str == "disabled"
				   || self.rightClickContextMenu_str == "default";
			if(!test) self.rightClickContextMenu_str = "developer";
			self.handIconPath_str = self.gridSkinPath_str + "hand.cur";
			self.grabIconPath_str = self.gridSkinPath_str + "grab.cur";
		
			self.comboBoxPosition_str = self.props_obj.comboBoxPosition || "topright";
			self.comboBoxPosition_str = self.comboBoxPosition_str.toLowerCase();
			test = self.comboBoxPosition_str.toLowerCase() == "topright" 
				   || self.comboBoxPosition_str.toLowerCase() == "topleft";
			if(!test) self.comboBoxPosition_str = "topright";
			
			self.buttonsAlignment_str = self.props_obj.buttonsAlignment || "in";
			var test = self.buttonsAlignment_str == "in" 
				   || self.buttonsAlignment_str == "out";
			if(!test) self.buttonsAlignment_str = "in";
			
			self.thumbnailLoadingType_str = String(self.props_obj.thumbnailLoadingType).toLowerCase() || "default";
			var test = self.thumbnailLoadingType_str == "loadmorewithbutton" 
				   || self.thumbnailLoadingType_str == "loadmoreonscroll"
				   || self.thumbnailLoadingType_str == "default";
			if(!test) self.thumbnailLoadingType_str = "default";
			
			
			self.hideAndShowTransitionType_str = String(self.props_obj.hideAndShowTransitionType).toLowerCase() || "scale";
			var test = self.hideAndShowTransitionType_str == "scale" 
				   || self.hideAndShowTransitionType_str == "opacity"
			       || self.hideAndShowTransitionType_str == "rotation"
				   || self.hideAndShowTransitionType_str == "none";
			if(!test) self.hideAndShowTransitionType_str = "scale";
			if(!FWDVRLUtils.hasTransform2d) self.hideAndShowTransitionType_str = "none";
			
			self.textVerticalAlign_str = String(self.props_obj.textVerticalAlign).toLowerCase() || "center";
			var test = self.textVerticalAlign_str == "center" 
				   || self.textVerticalAlign_str == "top"
			       || self.textVerticalAlign_str == "bottom";
			if(!test) self.textVerticalAlign_str = "center";
		
			self.imageTransitionDirection_str = String(self.props_obj.curtainRevealDirection).toLowerCase() || "top";
			var test = self.imageTransitionDirection_str == "top" 
				   || self.imageTransitionDirection_str == "bottom"
				   || self.imageTransitionDirection_str == "left"
			       || self.imageTransitionDirection_str == "right";
			if(!test) self.imageTransitionDirection_str = "top";
			
			self.menuPosition_str = String(self.props_obj.menuPosition).toLowerCase() || "center";
			var test = self.menuPosition_str == "center"
		 	     || self.menuPosition_str == "left"
		 	     || self.menuPosition_str == "right";
			
			if(!test) self.menuPosition_str = "center";
			
			self.textAnimType_str = String(self.props_obj.textAnimationType).toLowerCase() || "opacity";
			var test = self.textAnimType_str == "opacity"
			 	     || self.textAnimType_str == "scale"
			 	     || self.textAnimType_str == "scalerandom"
					 || self.textAnimType_str == "largescale";
			
		
			
			self.menuType_str = String(self.props_obj.menuType).toLowerCase() || "list";
			var test = self.menuType_str == "list" || self.menuType_str == "combobox";
			
			
			if(!test) self.menuType_str = "list";
		
			
			self.warningIconPath_str = self.gridSkinPath_str + "warning.png";
			
			self.searchLabel_str = self.props_obj.searchLabel;
			self.searchClassName_str = self.props_obj.searchClassName;
			self.searchClassName_str = "searchClassName";
			self.searchNotFoundClassName_str = "searchNotFound";
			self.searchNotFoundLabel_str = self.props_obj.searchNotFoundLabel;
			self.comboboxSelectorLabel_str = self.props_obj.comboboxSelectorLabel;
			self.ytbTitleClassName_str = self.props_obj.ytbTitleClassName;
			self.ytbDescriptionClassName_str = self.props_obj.ytbDescriptionClassName;
			self.comboboxArrowNormalColor_str =  self.props_obj.comboboxArrowNormalColor || "#000000";
			self.comboboxArrowSelectedColor_str =  self.props_obj.comboboxArrowSelectedColor || "#000000";;
			self.showYtbTitle_bl = self.props_obj.showYtbTitle == "yes" ? true : false;
			self.showSearchButton_bl = self.props_obj.showSearchBox == "yes" ? true : false;
			self.showYtbDescription_bl = self.props_obj.showYtbDescription == "yes" ? true : false;
			self.centerNoSearchFoundLabelWithMenu_bl = self.props_obj.centerNoSearchFoundLabelWithMenu == "no" ? false : true;
			
			self.ytbTitleMaxLength = parseInt(self.props_obj.ytbTitleMaxLength);
		
			self.facebookTitleClassName_str = self.props_obj.facebookTitleClassName;
			self.facebookDescriptionClassName_str = self.props_obj.facebookDescriptionClassName;
			self.showFacebookTitle_bl = self.props_obj.showFacebookTitle == "yes" ? true : false;
			self.showFacebookDescription_bl = self.props_obj.showFacebookDescription == "yes" ? true : false;
			self.facebookTitleMaxLength = parseInt(self.props_obj.facebookTitleMaxLength);
			
			self.soundCloudTitleClassName_str = self.props_obj.soundCloudTitleClassName;
			self.soundCloudTrackClassName_str = self.props_obj.soundCloudTrackClassName;
			self.showSoundCloudUserName_bl = self.props_obj.showSoundCloudTitle == "yes" ? true : false;
			self.showSoundCloudTrack_bl = self.props_obj.showSoundCloudTrack == "yes" ? true : false;
			
			self.pintrestDescriptionClassName_str = self.props_obj.pintrestDescriptionClassName;
			self.showPintrestDescription_bl = self.props_obj.showPintrestDescription == "yes" ? true : false;
			self.showPinButton_bl = self.props_obj.usePinIconButton == "yes" ? true : false;
			
			self.flickrAPIKey_str = self.props_obj.flickrAppId;
			self.flickrTitleClassName_str = self.props_obj.flickrTitleClassName;
			self.showFlickrkDescription_bl = self.props_obj.showFlickrDescription == "yes" ? true : false;
			self.flickrTitleMaxLength = parseInt(self.props_obj.flickrDescriptionMaxLength);
			
			if(parent.gridType_str == "classicvertical"
			   || parent.gridType_str == "masonryvertical"
			   || parent.gridType_str == "flexiblevertical"){
				self.showAsExtraText_bl = self.props_obj.showAsExtraText == "yes" ? true : false;
			}
		
		
			if(!FWDVRLUtils.hasTransform2d){
				test = false;
			}
			
			self.thumbanilBoxShadow_str = self.props_obj.thumbanilBoxShadow || "none";
			
			self.presetType_str = String(self.props_obj.preset).toLowerCase();
			if(self.presetType_str == "3d" && !FWDVRLUtils.hasTransform3d){
				self.presetType_str = "movetext";
			}
		
			self.allCategoriesLabel_str = self.props_obj.allCategoriesLabel;
			self.slideShowAutoPlay_str = self.props_obj.slideShowAutoPlay;
			self.addKeyboardSupport_str = self.props_obj.addKeyboardSupport;
			self.showCloseButton_str = self.props_obj.showCloseButton;
			self.showShareButton_str = self.props_obj.showShareButton;
			self.showZoomButton_str = self.props_obj.showZoomButton;
			self.showSlideShowButton_str = self.props_obj.showSlideShowButton;
			self.showSlideShowAnimation_str = self.props_obj.showSlideShowAnimation;
			self.showNextAndPrevButtons_str = self.props_obj.showNextAndPrevButtons;
			self.showNextAndPrevButtonsOnMobile_str = self.props_obj.showNextAndPrevButtonsOnMobile;
			self.itemBoxShadow_str = self.props_obj.itemBoxShadow;
			self.itemBackgroundColor_str = self.props_obj.itemBackgroundColor;
			self.itemBorderColor_str =  self.props_obj.itemBorderColor;
			self.backgroundColor_str = self.props_obj.lightboxBackgroundColor;
			self.showDescriptionButton_str = self.props_obj.showDescriptionButton;
			self.showDescriptionByDefault_str = self.props_obj.showDescriptionByDefault;
			self.descriptionWindowAnimationType_str = self.props_obj.descriptionWindowAnimationType;
			self.descriptionWindowPosition_str = self.props_obj.descriptionWindowPosition;
			self.useAsModal_str = self.props_obj.useAsModal;
			self.descriptionWindowBackgroundColor_str = self.props_obj.descriptionWindowBackgroundColor;
			self.descriptionWindowBackgroundOpacity = self.props_obj.descriptionWindowBackgroundOpacity;
			self.useVideo_str = self.props_obj.useVideo;
			self.useAudio_str = self.props_obj.useAudio;
			self.videoShowFullScreenButton_str = self.props_obj.videoShowFullScreenButton;
			self.nextVideoOrAudioAutoPlay_str = self.props_obj.nextVideoOrAudioAutoPlay;
			self.videoAutoPlay_str = self.props_obj.videoAutoPlay;
			self.videoLoop_str = self.props_obj.videoLoop;
			self.audioAutoPlay_str = self.props_obj.audioAutoPlay;
			self.audioLoop_str = self.props_obj.audioLoop;
			self.videoControllerBackgroundColor_str = self.props_obj.videoControllerBackgroundColor;
			self.videoPosterBackgroundColor_str = self.props_obj.videoPosterBackgroundColor;
			self.videoPosterBackgroundColor_str = self.props_obj.videoPosterBackgroundColor;
			self.audioControllerBackgroundColor_str = self.props_obj.audioControllerBackgroundColor;
			self.timeColor_str = self.props_obj.timeColor;
			self.facebookAppId_str = self.props_obj.facebookAppId;
			
			self.backgroundColor_str = self.props_obj.backgroundColor || "transparent";
			self.lightBoxInfoWindowBackgroundColor_str =  self.props_obj.lightBoxInfoWindowBackgroundColor || "transparent";
			self.thumbnailBorderNormalColor_str = self.props_obj.thumbnailBorderNormalColor || "transparent";
			self.thumbnailBorderSelectedColor_str = self.props_obj.thumbnailBorderSelectedColor || "transparent";
			self.thumbnailBackgroundColor_str = self.props_obj.thumbnailBackgroundColor || "transparent";
			self.thumbnailOverlayColor_str = self.props_obj.thumbnailOverlayColor || "transparent";
			
			self.loadMoreButtonLabel_str = self.props_obj.loadMoreButtonLabel || "not defined";
			
			self.comboboxSelectorBackgroundNormalClassName_str = self.props_obj.comboboxSelectorBackgroundNormalClassName || "";
			self.comboboxSelectorBackgroundNormalClassName_str = "UGPMenuButtonBackgroundNormal";
			self.comboboxSelectorBackgroundSelectedClassName_str = self.props_obj.comboboxSelectorBackgroundSelectedClassName || "";
			self.comboboxSelectorBackgroundSelectedClassName_str = "UGPMenuButtonBackgroundSelected";
			self.comboboxSelectorTextNormalClassName_str = self.props_obj.comboboxSelectorTextNormalClassName || "";
			self.comboboxSelectorTextNormalClassName_str = "UGPMenuButtonTextNormal";
			self.comboboxSelectorTextSeectedClassName_str = self.props_obj.comboboxSelectorTextSeectedClassName || "";
			self.comboboxSelectorTextSeectedClassName_str = "UGPMenuButtonTextSelected";
			self.menuBackgroundClass_str = self.props_obj.menuBackgroundClassName || ""; 
			self.menuBackgroundClass_str = "UGPMenuBackground";
			self.menuButtonBackgroundNormalClassName_str = self.props_obj.menuButtonBackgroundNormalClassName || "";
			self.menuButtonBackgroundNormalClassName_str = "UGPMenuButtonBackgroundNormal";
			self.menuButtonBackgroundSelectedClassName_str = self.props_obj.menuButtonBackgroundSelectedClassName || "";
			self.menuButtonBackgroundSelectedClassName_str = "UGPMenuButtonBackgroundSelected";
			self.menuButtonTextNormalClassName_str = self.props_obj.menuButtonTextNormalClassName || "";
			self.menuButtonTextNormalClassName_str = "UGPMenuButtonTextNormal";
			self.menuButtonTextSeectedClassName_str = self.props_obj.menuButtonTextSeectedClassName || "";
			self.menuButtonTextSeectedClassName_str = "UGPMenuButtonTextSelected";
			self.menuButtonsSpacersClassName_str = self.props_obj.menuButtonsSpacersClassName || "";
			self.menuButtonsSpacersClassName_str = "UGPMenuButtonsSpacers";
			
			self.loadMoreButtonBackgroundNormalClassName_str = self.props_obj.loadMoreButtonBackgroundNormalClassName || "";
			self.loadMoreButtonBackgroundNormalClassName_str = "UGPLoadMoreButtonBackgroundNormal";
			self.loadMoreButtonBackgroundSelectedClassName_str = self.props_obj.loadMoreButtonBackgroundSelectedClassName || "";
			self.loadMoreButtonBackgroundSelectedClassName_str = "UGPLoadMoreButtonBackgroundSelected";
			self.loadMoreButtonTextNormalClassName_str = self.props_obj.loadMoreButtonTextNormalClassName || "";
			self.loadMoreButtonTextNormalClassName_str = "UGPLoadMoreButtonTextNormal";
			self.loadMoreButtonTextSeectedClassName_str = self.props_obj.loadMoreButtonTextSeectedClassName || "";
			self.loadMoreButtonTextSeectedClassName_str = "UGPLoadMoreButtonTextSelected";
			
			self.loadMoreButtonOffsetTop = self.props_obj.loadMoreButtonOffsetTop || 0;
			self.loadMoreButtonOffsetLeft = self.props_obj.loadMoreButtonOffsetLeft || 0;
			self.loadMoreButtonOffsetRight = self.props_obj.loadMoreButtonOffsetRight || 0;
			self.loadMoreButtonOffsetBottom = self.props_obj.loadMoreButtonOffsetBottom || 0;
			self.loadMoreButtonBorderSize = self.props_obj.loadMoreButtonBorderSize || 0;
			self.loadMoreButtonBorderRadius = self.props_obj.loadMoreButtonBorderRadius || 0;
			
			self.thumbnailMaxWidth = self.props_obj.thumbnailMaxWidth || 280;
			if(self.thumbnailMaxWidth < 20) self.thumbnailMaxWidth = 20;
			self.thumbnailMaxHeight = self.props_obj.thumbnailMaxHeight || 240;
			if(self.thumbnailMaxHeight < 20) self.thumbnailMaxHeight = 20;
			self.thumbnailOverlayOpacity = self.props_obj.thumbnailOverlayOpacity == undefined ? 1 : self.props_obj.thumbnailOverlayOpacity;
			self.spaceBetweenThumbanilIcons = self.props_obj.spaceBetweenThumbanilIcons || 5;
			self.spaceBetweenTextAndIcons = self.props_obj.spaceBetweenTextAndIcons || 0;

			self.howManyThumbnailsToDisplayPerSet = parseInt(self.props_obj.howManyThumbnailsToDisplayPerSet) || 2;
			if(self.howManyThumbnailsToDisplayPerSet < 2) self.howManyThumbnailsToDisplayPerSet = 2;
			if(self.thumbnailLoadingType_str == "default")  self.howManyThumbnailsToDisplayPerSet = 1000;
			self.menuMaxWidth = self.props_obj.menuMaxWidth || 500;
			self.menuOffsetTop = self.props_obj.menuOffsetTop || 0;
			self.menuButtonsSapcerLeftAndRight = self.props_obj.menuButtonsSapcerLeftAndRight || 0;
			self.menuOffsetBottom = self.props_obj.menuOffsetBottom || 0;
			self.horizontalSpaceBetweenMenuButtons = self.props_obj.horizontalSpaceBetweenMenuButtons || 0;
			self.verticalSpaceBetweenMenuButtons = self.props_obj.verticalSpaceBetweenMenuButtons || 0;
			self.menuButtonSpacerWidth = self.props_obj.menuButtonSpacerWidth || 0;
			self.menuButtonSpacerHeight = self.props_obj.menuButtonSpacerHeight || 0;
			self.thumbnailBorderSize = self.props_obj.thumbnailBorderSize || 0;
			self.thumbnailBorderRadius = self.props_obj.thumbnailBorderRadius || 0;
			self.loadMoreButtonOffsetTop = self.props_obj.loadMoreButtonOffsetTop || 0;
			self.loadMoreButtonOffsetBottom = self.props_obj.loadMoreButtonOffsetBottom || 0;
			
			self.lightBoxBackgroundColor_str = self.props_obj.lightBoxBackgroundColor || "transparent";
			self.lightBoxInfoWindowBackgroundOpacity =  self.props_obj.lightBoxInfoWindowBackgroundOpacity || 1;
			self.lightBoxBackgroundOpacity = self.props_obj.lightBoxInfoWindowBackgroundOpacity || 1;
			self.lightBoxMainBackgroundOpacity = self.props_obj.lightBoxMainBackgroundOpacity || 1;
			self.lightBoxItemBorderColor_str = self.props_obj.lightBoxItemBorderColor || "transparent";
			self.lightBoxItemBackgroundColor_str = self.props_obj.lightBoxItemBackgroundColor || "transparent";
			
			self.buttonsOffestY = 0;
			self.contentOffsetY = 0;
			self.lightBoxBorderSize = self.props_obj.lightBoxBorderSize || 0;
			self.lightBoxSlideShowDelay = self.props_obj.lightBoxSlideShowDelay * 1000 || 3000;
			self.startAtCategory_ar = [parseInt(self.props_obj.startAtCategory)];
			self.buttonsHideDelay = self.props_obj.buttonsHideDelay;
			self.slideShowDelay = self.props_obj.slideShowDelay;
			self.defaultItemWidth = self.props_obj.defaultItemWidth;
			self.defaultItemHeight = self.props_obj.defaultItemHeight;
			self.itemOffsetHeight = self.props_obj.itemOffsetHeight;
			self.spaceBetweenButtons = self.props_obj.spaceBetweenButtons;
			self.buttonsOffsetIn = self.props_obj.buttonsOffsetIn;
			self.buttonsOffsetOut = self.props_obj.buttonsOffsetOut;
			self.itemBorderSize = self.props_obj.itemBorderSize || 0;
			self.itemBorderRadius = self.props_obj.itemBorderRadius || 0;
			self.thumbnailIconWidth = self.props_obj.thumbnailIconWidth || 20;
			self.thumbnailIconHeight = self.props_obj.thumbnailIconHeight || 0;
			self.backgroundOpacity = self.props_obj.backgroundOpacity;
			self.horizontalSpaceBetweenThumbnails = self.props_obj.horizontalSpaceBetweenThumbnails || 0;
			self.verticalSpaceBetweenThumbnails = self.props_obj.verticalSpaceBetweenThumbnails || 0;
			self.thumbnailsHorizontalOffset = self.props_obj.thumbnailsHorizontalOffset || 0;
			self.thumbnailsVerticalOffset = self.props_obj.thumbnailsVerticalOffset || 0;
			
		
			self.useIconButtons_bl = self.props_obj.useIconButtons;
			self.useIconButtons_bl = self.useIconButtons_bl == "yes" ? true : false;
			
			self.inverseButtonsIcons_bl = self.props_obj.inverseButtonsIcons;
			self.inverseButtonsIcons_bl = self.inverseButtonsIcons_bl == "yes" ? true : false;
			
			if(self.inverseButtonsIcons_bl){
				self.linkIconPathN_str = self.gridSkinPath_str + "link-icon-with-background.png";
				self.linkIconPathS_str = self.gridSkinPath_str + "link-icon.png";
			}else{
				self.linkIconPathN_str = self.gridSkinPath_str + "link-icon.png";
				self.linkIconPathS_str = self.gridSkinPath_str + "link-icon-with-background.png";
			}
			
			self.disableThumbnailsInteractivity_bl = self.props_obj.disableThumbnailsInteractivity;
			self.disableThumbnailsInteractivity_bl = self.disableThumbnailsInteractivity_bl == "yes" ? true : false;
			
			self.disableThumbnails_bl = self.props_obj.disableThumbnails; 
			self.disableThumbnails_bl = self.disableThumbnails_bl == "no" ? false : true;
			
			self.addMouseWheelSupport_bl = self.props_obj.addMouseWheelSupport; 
			self.addMouseWheelSupport_bl = self.addMouseWheelSupport_bl == "yes" ? true : false;
			
			
			
			self.addLightBoxKeyboardSupport_bl = self.props_obj.addLightBoxKeyboardSupport; 
			self.addLightBoxKeyboardSupport_bl = self.addLightBoxKeyboardSupport_bl == "no" ? false : true;
			
			self.showLighBoxNextAndPrevButtons_bl = self.props_obj.showLightBoxNextAndPrevButtons; 
			self.showLighBoxNextAndPrevButtons_bl = self.showLighBoxNextAndPrevButtons_bl == "no" ? false : true;
			
			self.showLightBoxZoomButton_bl = self.props_obj.showLightBoxZoomButton; 
			self.showLightBoxZoomButton_bl = self.showLightBoxZoomButton_bl == "no" ? false : true;
			
			self.showLightBoxInfoButton_bl = self.props_obj.showLightBoxInfoButton;
			self.showLightBoxInfoButton_bl = self.showLightBoxInfoButton_bl == "no" ? false : true;
			
			self.showLighBoxSlideShowButton_bl =  self.props_obj.showLighBoxSlideShowButton;
			self.showLighBoxSlideShowButton_bl =  self.showLighBoxSlideShowButton_bl == "no" ? false : true;
		
			self.showAllCategories_bl = self.props_obj.showAllCategories;
			self.showAllCategories_bl = self.showAllCategories_bl == "yes" ? true : false;
			
			self.keepThumbnailsOriginalSizeOnGridStart_bl = self.props_obj.keepThumbnailsOriginalSizeOnGridStart;
			self.keepThumbnailsOriginalSizeOnGridStart_bl = self.keepThumbnailsOriginalSizeOnGridStart_bl == "yes" ? true : false;
		
			self.randomizeCategories_bl = self.props_obj.randomizeCategories;
			self.randomizeCategories_bl = self.randomizeCategories_bl == "yes" ? true : false;
			
			self.animateParent_bl = self.props_obj.animateParent;
			self.animateParent_bl = self.animateParent_bl == "yes" ? true : false;
			
			
			self.showMenu_bl = self.props_obj.showMenu;
			self.showMenu_bl = self.showMenu_bl == "yes" ? true : false;
			
			self.showMenuButtonsSpacers_bl = self.props_obj.showMenuButtonsSpacers;
			self.showMenuButtonsSpacers_bl = self.showMenuButtonsSpacers_bl == "yes" ? true : false;
			
			self.multipleCategorySelection_bl = self.props_obj.multipleCategorySelection;
			self.multipleCategorySelection_bl = self.multipleCategorySelection_bl == "yes" ? true : false;
			
			self.showTotalThumbnailsPerCategory_bl = self.props_obj.showTotalThumbnailsPerCategory;
			self.showTotalThumbnailsPerCategory_bl = self.showTotalThumbnailsPerCategory_bl == "yes" ? true : false;
			
			self.scaleImage_bl = self.scaleImage == "no" ? false : true;	
			
			//#################################//
			//create playlists
			//#################################//
			self.playListElement = FWDVRLUtils.getChildById(self.props_obj.playlistId);
			if(!self.playListElement){
				self.playlistErrorHandler();
				return;
			}
			
			self.allPlaylists_ar = FWDVRLUtils.getChildren(self.playListElement);
			self.totalPlaylists = self.allPlaylists_ar.length;
			if(self.totalPlaylists <= 1){
				self.showAllCategories_bl = false;
			}
		
			//Check if youtube
			for(var j=0; j<self.totalPlaylists; j++){
				if(FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-soundcloud-url")){
					self.isSoundcloud_bl = true;
				}else if(FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-youtube-playlist-url")){
					self.isYoutube_bl = true;
				}else if(FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-facebook-album-url")){
					self.isFacebook_bl = true;
				}else if(FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-pintrest-board-url")){
					self.isPintrest_bl = true;
				}else if(FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-flickr-album-url")){
					self.isFlickr_bl = true;
				}
			}
	
			if(self.isSoundcloud_bl){
				self.soundCloudData_ar = [];
				self.soundCloudLoadId = 0;
				
				for(var j=0; j<self.totalPlaylists; j++){
					var ch = self.allPlaylists_ar[j];
					
					if(FWDVRLUtils.getAttributeValue(ch, "data-soundcloud-url")){
						self.soundCloudData_ar[j] = FWDVRLUtils.getAttributeValue(ch, "data-soundcloud-url");
					}
					
					self.categories_ar[j] = FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-category-name");
				}
				FWDVUGPData.isSoundCloud_bl = true;
			}else if(self.isYoutube_bl){
				self.youtubeData_ar = [];
				self.youtubeLoadId = 0;
			
				for(var j=0; j<self.totalPlaylists; j++){
					var ch = self.allPlaylists_ar[j];
					if(FWDVRLUtils.getAttributeValue(ch, "data-youtube-playlist-url")){
						var id_str =FWDVRLUtils.getAttributeValue(ch, "data-youtube-playlist-url").match(/list=([^&]+)/i)[1];
						self.youtubeData_ar[j] = id_str;
					}
					self.categories_ar[j] = FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-category-name");
				}
			}else if(self.isFacebook_bl){
		
				self.facebookData_ar = [];
				self.facebookLoadId = 0;
				self.isAPIReady_bl = false;
				
				for(var j=0; j<self.totalPlaylists; j++){
					var ch = self.allPlaylists_ar[j];
					var id_str;
				
					if(FWDVRLUtils.getAttributeValue(ch, "data-facebook-album-url")){
						id_str = FWDVRLUtils.getAttributeValue(ch, "data-facebook-album-url");;
						self.facebookData_ar[j] = String(id_str.match(/[\.][0-9]*[\.|&]/i)[0]).replace(/\.|&/g,"");
					}
					
					self.categories_ar[j] = FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-category-name");
				}
				FWDVUGPData.isFaceBook_bl = true;
			}else if(self.isPintrest_bl){
				FWDVUGPData.isPintrest_bl = true;
				self.pinterestData_ar = [];
				self.pintrestLoadId = 0;
				self.countPN = 0;
				self.isAPIReady_bl = false;
				
				if(self.showPinButton_bl){
					window.pAsyncInit = function() {
						PDK.init({
							appId: "nada", // Change this
							cookie: true
						});
					};

					(function(d, s, id){
						var js, pjs = d.getElementsByTagName(s)[0];
						if (d.getElementById(id)) {return;}
						js = d.createElement(s); js.id = id;
						js.src = "//assets.pinterest.com/sdk/sdk.js";
						pjs.parentNode.insertBefore(js, pjs);
					}(document, 'script', 'pinterest-jssdk'));
				};
				
				
				if(self.inverseButtonsIcons_bl){
					self.linkIconPathN_str = self.gridSkinPath_str + "pin-icon-with-background.png";
					self.linkIconPathS_str = self.gridSkinPath_str + "pin-icon.png";
				}else{
					self.linkIconPathN_str = self.gridSkinPath_str + "pin-icon.png";
					self.linkIconPathS_str = self.gridSkinPath_str + "pin-icon-with-background.png";
				}
				
				
				for(var j=0; j<self.totalPlaylists; j++){
					var ch = self.allPlaylists_ar[j];
					var id_str;
				
					if(FWDVRLUtils.getAttributeValue(ch, "data-pintrest-board-url")){
						id_str = FWDVRLUtils.getAttributeValue(ch, "data-pintrest-board-url");
						self.pinterestData_ar[j] = "https://api.pinterest.com/v3/pidgets/boards/" + String(id_str.match(/pinterest[^\/]+\/(.+)/i)[1]) + "pins";
					}
					
					self.categories_ar[j] = FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-category-name");
				}
				
			}else if(self.isFlickr_bl){
		
				FWDVUGPData.isFlickr_bl = true;
				self.flickrData_ar = [];
				self.flickrLoadId = 0;
				self.isAPIReady_bl = false;
				
				for(var j=0; j<self.totalPlaylists; j++){
					var ch = self.allPlaylists_ar[j];
					var id_str;
				
					if(FWDVRLUtils.getAttributeValue(ch, "data-flickr-album-url")){
						id_str = FWDVRLUtils.getAttributeValue(ch, "data-flickr-album-url");
						self.flickrData_ar[j] = String(id_str.match(/[^\/]+$/i));
					}
					self.categories_ar[j] = FWDVRLUtils.getAttributeValue(self.allPlaylists_ar[j], "data-category-name");
				}
			}
			if(!self.isFacebook_bl) self.setupFacebook();
			
			self.prepareSiknForLoading();
		};
		
		//######################################//
		/* Load playlist */
		//#####################################//
		this.loadPlaylist = function(){
			if(self.isFlickr_bl){
				self.loadFlickrPlaylist();
			}else if(self.isSoundcloud_bl){
				self.loadSoundCloudPlaylist();
			}else if(self.isYoutube_bl){
				self.loadYoutubePlaylist();
			}else if(self.isPintrest_bl){
				self.loadPintrestPlaylist();
			}else if(self.isFacebook_bl){
				if(!self.accessToken_str){
					self.loadAccessFacebookAccessToken();
					return;
				}
				self.loadFacebookPlaylist();
			}else{
				self.loadHTMLPlaylist(self.allPlaylists_ar);
				self.loadSkin();
			}
		};
		
		//####################################//
		/* stop to load current playlist... */
		//####################################//
		this.stopToLoadPlaylist = function(){
			clearTimeout(self.JSONPRequestTimeoutId_to);
			
			try{
				self.scs_el.src = null;
				document.documentElement.removeChild(self.scs_el);
				self.scs_el = null;
			}catch(e){}
			
			
			if(self.xhr != null){
				try{self.xhr.abort();}catch(e){}
				self.xhr.onreadystatechange = null;
				self.xhr.onerror = null;
				self.xhr = null;
			}
		};
		
		
		//##########################################//
		/* load flickr list */
		//##########################################//
		this.loadFlickrPlaylist = function(){
			if(self.isPlaylistDispatchingError_bl) return;
			self.flickrUrl_str = self.flickrData_ar[self.flickrLoadId];
			self.stopToLoadPlaylist();
		
			url = "https://api.flickr.com/services/rest/?method=flickr.photosets.getPhotos&api_key=" + self.flickrAPIKey_str + "&photoset_id=" + self.flickrUrl_str + "&format=json&jsoncallback=" + parent.instanceName_str + ".data.parseflickrPlaylist";
			
			if(self.scs_el ==  null){
				try{
					self.scs_el = document.createElement('script');
					self.scs_el.src = url;
					self.scs_el.id = parent.instanceName_str + ".data.parseflickrPlaylist";
					document.documentElement.appendChild(self.scs_el);
				}catch(e){}
			}
			self.JSONPRequestTimeoutId_to = setTimeout(self.playlistErrorHandler, 8000);
		};
		
		this.parseflickrPlaylist = function(object){
			
			if(self.isPlaylistDispatchingError_bl) return;
			self.stopToLoadPlaylist();
		
			
			if(object.stat == "fail"){
				self.playlistErrorHandler();
				if(console) console.log(object);
				return;
			}
		
		
			self.flickrObject_ar = [];
			self.lightboxParsedPlaylist_ar = [];
			
			for(var i=0; i<object.photoset.photo.length; i++){
				self.flickrObject_ar.push(object.photoset.photo[i]);
			}
			
			var totalItems = self.flickrObject_ar.length;
			var curItem;
			var titleText_str;
			
			for(var i=0; i<totalItems; i++){
				var obj = {};
				curItem = self.flickrObject_ar[i];
				
				obj.catId = self.flickrLoadId;
				obj.url = "http://farm" + curItem.farm + ".staticflickr.com/" + curItem.server + "/"  + curItem.id + "_" + curItem.secret + "_b.jpg";
				obj.thumbnailPath_str = "http://farm" + curItem.farm + ".staticflickr.com/" + curItem.server + "/"  + curItem.id + "_" + curItem.secret + "_n.jpg";
			
				if(self.showFlickrkDescription_bl && curItem.title){
					
					if(curItem.title.length > self.flickrTitleMaxLength){
						titleText_str = curItem.title.substr(0, self.flickrTitleMaxLength) + " ...";
					}else{
						titleText_str = curItem.title;
					}
					
					obj.htmlContent1_str = "<div class='"  + self.flickrTitleClassName_str + "'>" + titleText_str + "</div>";
					obj.rawDescription_str = curItem.description;
					
					if(self.presetType_str == "animtext" && !self.showAsExtraText_bl){
						var source_str = titleText_str;
						var temp_ar;
						var tempStr_str;
						var str;
						var startString = String(obj.htmlContent1_str).match(/<[^<>]*>/)[0];
						var endingString = String(obj.htmlContent1_str).match(/<[^<>]*>/g)[1];
						obj.animText_ar = [];
						obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
						tempStr_str = startString;
						
						temp_ar = obj.htmlContent1_str.split("");
						for(var l=0; l<temp_ar.length; l++){
							str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
							tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
						}
						
						tempStr_str += endingString;
						
						obj.htmlContent1_str = tempStr_str;
					}
				}
				
				if(self.showAsExtraText_bl){
					obj.htmlExtraContent_str = obj.htmlContent1_str;
					obj.htmlContent1_str = undefined;
					self.hasExtraText_bl = true;
				}
				
				obj.titleText_str = titleText_str;
				obj.type_str = FWDVUGP.IMAGE;
				obj.iconType_str = FWDVUGP.IMAGE;
				if(self.inverseButtonsIcons_bl){
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon-with-background.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon.png";
				}else{
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon-with-background.png";
				}
				
				self.parsedPlaylist_ar.push(obj);
			}
			
			self.flickrLoadId ++;
			
			if(self.flickrLoadId < self.totalPlaylists){
				self.loadPlaylist();
			}else{
				self.finalizePlaylist();
				self.loadSkin();
			}
		};
	
		//##########################################//
		/* load pinterest list */
		//##########################################//
		this.loadPintrestPlaylist = function(){
			if(self.isPlaylistDispatchingError_bl) return;
			self.pinterestUrl_str = self.pinterestData_ar[self.pintrestLoadId];
			self.stopToLoadPlaylist();
		
			url = self.pinterestUrl_str + "?callback=" + parent.instanceName_str + ".data.parsePintrestPlaylist";
			
		
			if(self.scs_el ==  null){
				try{
					self.scs_el = document.createElement('script');
					self.scs_el.src = url;
					self.scs_el.id = parent.instanceName_str + ".data.parsePintrestPlaylist";
					document.documentElement.appendChild(self.scs_el);
				}catch(e){}
			}
			self.JSONPRequestTimeoutId_to = setTimeout(self.playlistErrorHandler, 8000);
		};
		
		this.parsePintrestPlaylist = function(object){
			
			if(self.isPlaylistDispatchingError_bl) return;
			self.stopToLoadPlaylist();
			
			if(object.status == "failure"){
				self.playlistErrorHandler();
				if(console) console.log(object);
				return;
			}
		
			self.pintrestObject_ar = [];
			self.lightboxParsedPlaylist_ar = [];
			
			for(var i=0; i<object.data.pins.length; i++){
				self.pintrestObject_ar.push(object.data.pins[i]);
			}
		
			var totalItems = self.pintrestObject_ar.length;
			var curItem;
			var titleText_str = "";
			
			for(var i=0; i<totalItems; i++){
				var obj = {};
				curItem = self.pintrestObject_ar[i];
				
				obj.catId = self.pintrestLoadId;
				obj.url = "https://www.pinterest.com/pin/" + curItem.id;
				obj.thumbnailPath_str = curItem.images["237x"].url;
				obj.pinLInk_str = curItem.link;
				if(self.showPinButton_bl) obj.extraButtonUrl_str = "pinterest";
		
				if(self.showPintrestDescription_bl && curItem.description && curItem.description != " "){	
				
					if(curItem.description){
						titleText_str = curItem.description;
					}
				
					obj.htmlContent1_str = "<div class='"  + self.pintrestDescriptionClassName_str + "'>" + curItem.description + "</div>";
					obj.rawDescription_str = curItem.description;
					
					if(self.presetType_str == "animtext" && !self.showAsExtraText_bl){
						var source_str = titleText_str;
						var temp_ar;
						var tempStr_str;
						var str;
						var startString = String(obj.htmlContent1_str).match(/<[^<>]*>/)[0];
						var endingString = String(obj.htmlContent1_str).match(/<[^<>]*>/g)[1];
						obj.animText_ar = [];
						obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
						tempStr_str = startString;
						
						temp_ar = obj.htmlContent1_str.split("");
						for(var l=0; l<temp_ar.length; l++){
							str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
							tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
						}
						
						tempStr_str += endingString;
						
						obj.htmlContent1_str = tempStr_str;
					}
				}
				
				if(self.showAsExtraText_bl ){
					obj.htmlExtraContent_str = obj.htmlContent1_str;
					obj.htmlContent1_str = undefined;
					self.hasExtraText_bl = true;
				}
				
				obj.titleText_str = titleText_str;
				obj.type_str = FWDVUGP.LINK;
				obj.iconType_str = FWDVUGP.IMAGE;
				if(self.inverseButtonsIcons_bl){
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon-with-background.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon.png";
				}else{
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon-with-background.png";
				}
				
				self.parsedPlaylist_ar.push(obj);
			}
			
			self.pintrestLoadId ++;
			
			if(self.pintrestLoadId < self.totalPlaylists){
				self.loadPlaylist();
			}else{
				self.finalizePlaylist();
				self.loadSkin();
			}
		};
		
		//##########################################//
		/* load soundcloud list */
		//##########################################//
		this.loadSoundCloudPlaylist = function(){
			if(self.isPlaylistDispatchingError_bl) return;
			self.soundCloundUrl_str = self.soundCloudData_ar[self.soundCloudLoadId];
	
			self.stopToLoadPlaylist();
				
			if(self.soundCloundUrl_str.indexOf("likes") != -1){
				self.soundCloundUrl_str =  self.soundCloundUrl_str.replace(/\/likes$/, "/favorites");
			}
		
			if(self.soundCloundUrl_str.indexOf("api.soundcloud.") == -1){
				url = "http://api.soundcloud.com/resolve?format=json&url=" + self.soundCloundUrl_str + "&limit=100" + "&client_id=" + self.scClientId_str + "&callback=" + parent.instanceName_str + ".data.parseSoundCloudPlaylist";
			}else{
				url = self.sourceURL_str + "?format=json&client_id=" + self.scClientId_str  + "&limit=100" + "&callback=" + parent.instanceName_str + ".data.parseSoundCloudPlaylist";
			}
		
			if(self.scs_el ==  null){
				try{
					self.scs_el = document.createElement('script');
					self.scs_el.src = url;
					self.scs_el.id = parent.instanceName_str + ".data.parseSoundCloud";
					document.documentElement.appendChild(self.scs_el);
				}catch(e){}
			}
			self.JSONPRequestTimeoutId_to = setTimeout(self.playlistErrorHandler, 8000);
		};
		
		
		this.parseSoundCloudPlaylist = function(object){
			
			if(self.isPlaylistDispatchingError_bl) return;
			self.stopToLoadPlaylist();
			
			if(object.tracks){
				object = object.tracks;
			}else if(object.length){
				object = object;
			}else{
				self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:"Please provide a playlist or tracks URL : <font color='#FF0000'>" + self.soundCloundUrl_str + "</font>."});
				return;
			}
		
			self.soundCloudObject_ar = [];
			self.lightboxParsedPlaylist_ar = [];
			
			for(var i=0; i<object.length; i++){
				self.soundCloudObject_ar.push(object[i]);
			}
		
			var totalItems = self.soundCloudObject_ar.length;
			var curItem;
			var titleText_str;
		
			for(var i=0; i<totalItems; i++){
				var obj = {};
				var test;
				curItem = self.soundCloudObject_ar[i];
				
				obj.catId = self.soundCloudLoadId;
				obj.url = curItem.stream_url + "?consumer_key=" + self.scClientId_str;
				obj.thumbnailPath_str = String(curItem.artwork_url).replace(/large/, "t300x300");
				
				if(self.showSoundCloudUserName_bl || self.showSoundCloudTrack_bl){	
					titleText_str = curItem["user"]["username"] +  " - " + curItem["title"];
					
					if(self.presetType_str == "animtext" && self.showSoundCloudUserName_bl && !self.showAsExtraText_bl){
						obj.htmlContent1_str = "<div class='"  + self.soundCloudTitleClassName_str + "'>" + curItem["user"]["username"] +  " - " + curItem["title"] + "</div>";
					}else if(self.presetType_str){
						obj.htmlContent1_str = "<div class='"  + self.soundCloudTitleClassName_str + "'>" + curItem["user"]["username"] + "</div>" + "<div class='"  + self.soundCloudTrackClassName_str + "'>"  + curItem["title"] +  "</div>" ;
					}
				
					if(self.presetType_str == "animtext" && !self.showAsExtraText_bl){
						var source_str = titleText_str;
						var temp_ar;
						var tempStr_str;
						var str;
						var startString = String(obj.htmlContent1_str).match(/<[^<>]*>/)[0];
						var endingString = String(obj.htmlContent1_str).match(/<[^<>]*>/g)[1];
						obj.animText_ar = [];
						obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
						tempStr_str = startString;
						
						temp_ar = obj.htmlContent1_str.split("");
						for(var l=0; l<temp_ar.length; l++){
							str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
							tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
						}
						
						tempStr_str += endingString;
						
						obj.htmlContent1_str = tempStr_str;
						
					}
				}
				
				if(self.showAsExtraText_bl){
					obj.htmlExtraContent_str = obj.htmlContent1_str;
					obj.htmlContent1_str = undefined;
					self.hasExtraText_bl = true;
				}
				
				obj.titleText_str = titleText_str;
				obj.type_str = FWDVUGP.AUDIO;
				obj.iconType_str = FWDVUGP.AUDIO;
				if(self.inverseButtonsIcons_bl){
					obj.thumbIconPathN_str = self.gridSkinPath_str + "audio-icon-with-background.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "audio-icon.png";
				}else{
					obj.thumbIconPathN_str = self.gridSkinPath_str + "audio-icon.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "audio-icon-with-background.png";
				}
				
				self.parsedPlaylist_ar.push(obj);
			}
			
			self.soundCloudLoadId ++;
			
			if(self.soundCloudLoadId < self.totalPlaylists){
				self.loadPlaylist();
			}else{
				self.finalizePlaylist();
				self.loadSkin();
			}
		};
		
		//#########################################//
		/* Load facebook playlist */
		//#########################################//
		this.setupFacebook = function(){	
			if(document.location.protocol == "file:" && self.isFacebook_bl){
				self.isPlaylistDispatchingError_bl = true;
				showLoadPlaylistErrorId_to = setTimeout(function(){
					self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:"Please test online, is not possible to view Facebook albums local."});
					self.isPlaylistDispatchingError_bl = false;
				}, 50);
				return;
			}
			FWDVRLFacebookShare.setPrototype();
			self.facebookShare = new FWDVRLFacebookShare(self.facebookAppId_str);
			if(self.isFacebook_bl){
				self.facebookShare.addListener(FWDVRLFacebookShare.API_READY, self.facebookAPIReadyHandler);
				self.facebookShare.addListener(FWDVRLFacebookShare.API_ERROR, self.facebookAPIErrorHandler);
			}
		};
		
		this.facebookAPIReadyHandler = function(e){
			self.loadAccessFacebookAccessToken();
		};
		
		this.loadAccessFacebookAccessToken = function(){
			self.stopToLoadPlaylist();
			self.sourceURL_str = self.mainFolderPath_str + "facebook_access_token.txt";
			self.xhr = new XMLHttpRequest();
			self.xhr.onreadystatechange = self.facebookTokenOnLoadoadHandler;
			self.xhr.onerror = self.facebookAPIErrorHandler;
			
			try{
				self.xhr.open("get", self.sourceURL_str + "?rand=" + parseInt(Math.random() * 99999999), true);
				self.xhr.send();
			}catch(e){
				var message = e;
				if(e){if(e.message)message = e.message;}
				self.facebookAPIErrorHandler();
			}
		};
		
		this.facebookTokenOnLoadoadHandler = function(e){
			var response;
			
			if(self.xhr.readyState == 4){
				if(self.xhr.status == 404){
					self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:"Facebook token path is not found: <font color='#FF0000'>" + self.sourceURL_str + "</font>"});
				}else if(self.xhr.status == 408){
					self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:"Loadiong Facebook token file request load timeout!"});
				}else if(self.xhr.status == 200){
					if(window.JSON){
						response = JSON.parse(self.xhr.responseText);
					}else{
						response = eval('('+ self.xhr.responseText +')');
					}
				
					self.accessToken_str = response.access_token;
					self.loadPlaylist();
				}
			}
		};
		
		this.facebookAPIErrorHandler = function(e){
			try{
				if(window.console) console.log(e);
				if(window.console) console.log(e.message);
			}catch(e){};
			self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:"Error loading file : <font color='#FFFFFF'>" + self.sourceURL_str + "</font>. Make sure the path is correct"});
		};
		
		this.loadFacebookPlaylist = function(){
			FB.api(
				  '/' + self.facebookData_ar[self.facebookLoadId] + '?access_token=' + self.accessToken_str,
				  'GET',
				  {"fields":"photos.limit(100){images,created_time,name}"},
				  function(response) {
					  if (response){
						  self.parseFacebookPlaylist(response);
				      }
				  }
			);
		};
		
		this.parseFacebookPlaylist = function(object){
			if(self.isPlaylistDispatchingError_bl) return;
			self.stopToLoadPlaylist();
			
			if(object.error){
				self.playlistErrorHandler();
				if(console) console.dir(object);
				return;
			}
			
			self.facebookObject_ar = [];
			self.lightboxParsedPlaylist_ar = [];
			
			for(var i=0; i<object.photos.data.length; i++){
				self.facebookObject_ar.push(object.photos.data[i]);
			}
		
			var totalItems = self.facebookObject_ar.length;
			var curItem;
			var titleText_str;
			
			for(var i=0; i<totalItems; i++){
				var obj = {};
				var test;
				curItem = self.facebookObject_ar[i];
				
			
				obj.catId = self.facebookLoadId;
				obj.url = curItem.images[0].source;
				obj.thumbnailPath_str = curItem.images[curItem.images.length - 1].source;
				
				for(var j=curItem.images.length-1; j>=0; j--){
					if( parseInt(curItem.images[j].width) > 200 && parseInt(curItem.images[j].width) < 500){
						obj.thumbnailPath_str = curItem.images[j].source;
						break;
					}
				};
			
				if(self.showFacebookTitle_bl && curItem.name){
					
					if(curItem.name.length > self.facebookTitleMaxLength){
						titleText_str = curItem.name.substr(0, self.facebookTitleMaxLength) + " ...";
						obj.htmlContent1_str = "<div class='" + self.facebookTitleClassName_str + "'>" + titleText_str + "</div>";
					}else{
						titleText_str = curItem.name;
						obj.htmlContent1_str = "<div class='" + self.facebookTitleClassName_str + "'>" + titleText_str + "</div>";
					}
					
					if(self.presetType_str == "animtext"){
						var source_str = titleText_str;
						var temp_ar;
						var tempStr_str;
						var str;
						var startString = String(obj.htmlContent1_str).match(/<[^<>]*>/)[0];
						var endingString = String(obj.htmlContent1_str).match(/<[^<>]*>/g)[1];
						obj.animText_ar = [];
						obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
						tempStr_str = startString;
						
						temp_ar = obj.htmlContent1_str.split("");
						for(var l=0; l<temp_ar.length; l++){
							str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
							tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
						}
						
						tempStr_str += endingString;
						
						obj.htmlContent1_str = tempStr_str;
					}
					
				}
				
				if(self.showFacebookDescription_bl && curItem.name){
					obj.description = "<p class='" + self.facebookDescriptionClassName_str + "'>" + curItem.name + "</p>";
					obj.descriptionText = String(curItem.name).substr(0, self.facebookTitleMaxLength);
				}
				
				obj.titleText_str = titleText_str;
				obj.iconType_str = FWDVUGP.IMAGE;
				if(self.inverseButtonsIcons_bl){
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon-with-background.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon.png";
				}else{
					obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon.png";
					obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon-with-background.png";
				}
				
				self.parsedPlaylist_ar.push(obj);
			}
			
			self.facebookLoadId ++;
			
			if(self.facebookLoadId < self.totalPlaylists){
				self.loadFacebookPlaylist();
			}else{
				self.finalizePlaylist();
				self.loadSkin();
			}
		};
		
		//######################################//
		/* Load youtube playlists */
		//#####################################//
		this.loadYoutubePlaylist = function(){
			
			self.youtubeUrl_str = self.youtubeData_ar[self.youtubeLoadId];
			
			if(self.nextPageToken_str){
				self.sourceURL_str = "https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&pageToken=" + self.nextPageToken_str + "&playlistId=" + self.youtubeUrl_str + "&key=AIzaSyAlyhJ-C5POyo4hofPh3b7ECAxWy6t6lyg&maxResults=50&callback=" + parent.instanceName_str + ".data.parseYoutubePlaylist";
			}else{
				self.youtubeObject_ar = [];
				self.lightboxParsedPlaylist_ar = [];
				self.sourceURL_str = "https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&playlistId=" + self.youtubeUrl_str + "&key=AIzaSyAlyhJ-C5POyo4hofPh3b7ECAxWy6t6lyg&maxResults=50&callback=" + parent.instanceName_str + ".data.parseYoutubePlaylist";
			}
			
			if(self.scs_el == null){
				try{
					self.scs_el = document.createElement('script');
					self.scs_el.src = self.sourceURL_str;
					self.scs_el.id = parent.instanceName_str + ".data.parseYoutubePlaylist";
					document.documentElement.appendChild(self.scs_el);
				}catch(e){}
			}
			self.JSONPRequestTimeoutId_to = setTimeout(self.playlistErrorHandler, 6000);
		};
		
		this.parseYoutubePlaylist = function(object){
			
			if(self.isPlaylistDispatchingError_bl) return;
			self.stopToLoadPlaylist();
			
			if(object.error){
				self.playlistErrorHandler();
				if(console) console.dir(object);
				return;
			}
			
			for(var i=0; i<object.items.length; i++){
				self.youtubeObject_ar.push(object.items[i]);
			}
		
			if(object.nextPageToken){
				self.nextPageToken_str = object.nextPageToken;
				self.loadYoutubePlaylist();
				return;
			}
			
			
			var totalItems = self.youtubeObject_ar.length;
			var curItem;
			var videoSource;
			var titleText_str;
		
			for(var i=0; i<totalItems; i++){
				var obj = {};
				curItem = self.youtubeObject_ar[i];
				
				if(curItem.snippet.thumbnails){
					
					obj.catId = self.youtubeLoadId;
					obj.url = "https://www.youtube.com/watch?v=" + curItem.snippet.resourceId.videoId;
					obj.thumbnailPath_str = curItem.snippet.thumbnails.medium.url;
					
					if(self.showYtbTitle_bl){
						
						if(curItem.snippet.title.length > self.ytbTitleMaxLength){
							titleText_str = curItem.snippet.title.substr(0, self.ytbTitleMaxLength) + " ...";
							obj.htmlContent1_str = "<div class='" + self.ytbTitleClassName_str + "'>" + titleText_str + "</div>";
						}else{
							titleText_str = curItem.snippet.title;
							obj.htmlContent1_str = "<div class='" + self.ytbTitleClassName_str + "'>" + titleText_str + "</div>";
						}
						
						if(self.presetType_str == "animtext"){
							var source_str = titleText_str;
							var temp_ar;
							var tempStr_str;
							var str;
							var startString = String(obj.htmlContent1_str).match(/<[^<>]*>/)[0];
							var endingString = String(obj.htmlContent1_str).match(/<[^<>]*>/g)[1];
							obj.animText_ar = [];
							obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
							tempStr_str = startString;
							
							temp_ar = obj.htmlContent1_str.split("");
							for(var l=0; l<temp_ar.length; l++){
								str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
								tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
							}
							
							tempStr_str += endingString;
							
							obj.htmlContent1_str = tempStr_str;
						}
						
					}
					
					if(self.showYtbDescription_bl){
						obj.description = "<p class='" + self.ytbDescriptionClassName_str + "'>" + curItem.snippet.description + "</p>";
						obj.descriptionText = String(curItem.snippet.description).substr(0, self.ytbTitleMaxLength);
					}
					
					obj.titleText_str = titleText_str;
					obj.iconType_str = FWDVUGP.YOUTUBE;
					if(self.inverseButtonsIcons_bl){
						obj.thumbIconPathN_str = self.gridSkinPath_str + "youtube-icon-with-background.png";
						obj.thumbIconPathS_str = self.gridSkinPath_str + "youtube-icon.png";
					}else{
						obj.thumbIconPathN_str = self.gridSkinPath_str + "youtube-icon.png";
						obj.thumbIconPathS_str = self.gridSkinPath_str + "youtube-icon-with-background.png";
					}
					
					self.parsedPlaylist_ar.push(obj);
				}
			}
			
			self.youtubeLoadId ++;
			
			if(self.youtubeLoadId < self.totalPlaylists){
				self.nextPageToken_str = undefined;
				self.loadYoutubePlaylist();
			}else{
				self.finalizePlaylist();
				self.loadSkin();
			}
		};
		
		
		this.playlistErrorHandler = function(){
			var info_str;
			
			if(self.isFlickr_bl){
				info_str = "Error loading Flickr album! - <font color='#FF0000'>" + self.flickrData_ar[self.flickrLoadId] + "</font>";
			}else if(self.isSoundcloud_bl){
				info_str = "Error loading Soundcloud playlist! - <font color='#FF0000'>" + self.soundCloudData_ar[self.soundCloudLoadId] + "</font>";
			}else if(self.isFacebook_bl){
				info_str = "Error loading Facebook playlist! - <font color='#FF0000'>" + self.facebookData_ar[self.facebookLoadId] + "</font>";
			}else if(self.isYoutube_bl){
				info_str = "Error loading Youtube playlist! - <font color='#FF0000'>" + self.youtubeData_ar[self.youtubeLoadId] + "</font>";
			}else if(self.isPintrest_bl){
				info_str = "Error loading Pintrest playlist! - <font color='#FF0000'>" + self.pinterestData_ar[self.pintrestLoadId] + "</font>";
			}else{
				info_str = "Playlist div with the id! - <font color='#FF0000'>" + self.props_obj.playlistId + "</font> doesn't exists.";
			}
			
			self.stopToLoadPlaylist();
			self.isPlaylistDispatchingError_bl = true;
			showLoadPlaylistErrorId_to = setTimeout(function(){
				self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:info_str});
				self.isPlaylistDispatchingError_bl = false;
			}, 50);
			return;
		};
		
		//######################################//
		/* Load html playlist */
		//#####################################//
		this.loadHTMLPlaylist = function(allPlaylists_ar){
			
			var curPlaylist_ar;
			self.parsedPlaylist_ar = [];
			self.lightboxParsedPlaylist_ar = [];
			var totalItems;
			var curCat;
			var curItem;
			var titleText_str;
			
			for(var j=0; j<self.totalPlaylists; j++){
				curPlaylist_ar = FWDVRLUtils.getChildren(allPlaylists_ar[j]);
				//parsedPlaylist_ar = [];
				//lightboxParsedPlaylist_ar = [];
				totalItems = curPlaylist_ar.length;
				curCat = j;
				curItem = 0;
				
				for(var i=0; i<totalItems; i++){
					var obj = {};
					var ch = curPlaylist_ar[i];
					var test;
					titleText_str = "";
					curItem = i;
					
					if(!FWDVRLUtils.hasAttribute(ch, "data-url")){
						errorMessage_str = "Attribute <font color='#FF0000'>data-url</font> is not found in the playlist at position nr: <font color='#FF0000'>" + i + "</font>.";
						self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:errorMessage_str});
						return;
					}
					
					obj.catId = j;
					obj.url = String(FWDVRLUtils.getAttributeValue(ch, "data-url"));
					obj.target = FWDVRLUtils.getAttributeValue(ch, "data-target") || "_blank";
					obj.posterPath = FWDVRLUtils.getAttributeValue(ch, "data-poster-path");
					obj.type_str = FWDVRLUtils.getAttributeValue(ch, "data-url");
					obj.width = FWDVRLUtils.getAttributeValue(ch, "data-width");
					obj.height = FWDVRLUtils.getAttributeValue(ch, "data-height");
					obj.extraButtonUrl_str = FWDVRLUtils.getAttributeValue(ch, "data-extra-button-url");
					obj.extraButtonUrlTarget_str = FWDVRLUtils.getAttributeValue(ch, "data-extra-button-target") || "_blank";
					obj.disabled_bl = obj.url == "none" ? true : false;
					obj.thumbnailBorderNormalColor = FWDVRLUtils.getAttributeValue(ch, "data-thumbnail-border-normal-color");
					obj.thumbnailBorderSelectedColor = FWDVRLUtils.getAttributeValue(ch, "data-thumbnail-border-selected-color");
					obj.thumbnailOverlayColor = FWDVRLUtils.getAttributeValue(ch, "data-thumbnail-overlay-color");
					
					var contentCh = FWDVRLUtils.getChildren(ch);
					
					
					var ch2;
					var hasThumbnail_bl = false;
					for(var k=0; k<contentCh.length; k++){
						ch2 = contentCh[k];
						
						if(FWDVRLUtils.hasAttribute(ch2, "src")){
							hasThumbnail_bl = true;
							obj.thumbnailPath_str = FWDVRLUtils.getAttributeValue(ch2, "src");
							obj.alt_str = FWDVRLUtils.getAttributeValue(ch2, "alt") || "";
						}
						
						if(FWDVRLUtils.hasAttribute(ch2, "data-lightbox-desc")) {
							obj.description = ch2.innerHTML;
							obj.descriptionText = ch2.innerText;
						}
						
						if(FWDVRLUtils.hasAttribute(ch2, "data-thumbnail-content1")){
							if(self.presetType_str == "animtext"){
								var source_str = ch2.innerText || ch2.textContent;
								var temp_ar;
								var tempStr_str;
								var str;
								var startString = String(ch2.innerHTML).match(/<[^<>]*>/)[0];
								var endingString = String(ch2.innerHTML).match(/<[^<>]*>/g)[1];
								obj.animText_ar = [];
								obj.htmlContent1_str = source_str.replace(/(^[\s]+|[\s]+$)/g, '');
								tempStr_str = startString;
								
								temp_ar = obj.htmlContent1_str.split("");
								for(var l=0; l<temp_ar.length; l++){
									str = temp_ar[l] == " " ? "&nbsp" : temp_ar[l];
									tempStr_str += "<div style='position:relative;display:inline-block;'>" + str + "</div>";
								}
								
								tempStr_str += endingString;
								obj.htmlContent1_str = tempStr_str;
							}else{
								obj.htmlContent1_str = ch2.innerHTML;
							}
							titleText_str += ch2.innerText || ch2.textContent;
						}
						
						if(FWDVRLUtils.hasAttribute(ch2, "data-thumbnail-content2")) {
							obj.htmlContent2_str = ch2.innerHTML;
							titleText_str += ch2.innerText || ch2.textContent;
						}
						
						if(FWDVRLUtils.hasAttribute(ch2, "data-thumbnail-extra-content")){
							obj.htmlExtraContent_str = ch2.innerHTML;
							titleText_str += ch2.innerText || ch2.textContent;
							self.hasExtraText_bl = true;
						}
						
						obj.titleText_str = titleText_str;
					}
					
					

					if(!hasThumbnail_bl){
						errorMessage_str = "Thumbnail image is not found at category: <font color='#FF0000'>" + (curCat + 1) + "</font> at position nr: <font color='#FF0000'>" + (curItem + 1) + "</font>";
						self.dispatchEvent(FWDVUGPData.LOAD_ERROR, {text:errorMessage_str});
						return;
					}
					
					if(/none/i.test(obj.type_str)){
						obj.iconType_str = FWDVUGP.NONE;
						obj.type_str = FWDVUGP.NONE;
						obj.thumbIconPathN_str = undefined;
						obj.thumbIconPathS_str = undefined;
					}else if(/\.jpg|\.jpeg|\.png/i.test(obj.type_str)){
						obj.iconType_str = FWDVUGP.IMAGE;
						obj.type_str = FWDVUGP.IMAGE;
						if(self.inverseButtonsIcons_bl){
							obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon-with-background.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon.png";
						}else{
							obj.thumbIconPathN_str = self.gridSkinPath_str + "image-icon.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "image-icon-with-background.png";
						}
						
						obj.width = undefined;
						obj.height = undefined;
					}else if(/\.mp4/i.test(obj.type_str)){
						obj.iconType_str = FWDVUGP.VIDEO;
						obj.type_str = FWDVUGP.VIDEO;
						if(self.inverseButtonsIcons_bl){
							obj.thumbIconPathN_str = self.gridSkinPath_str + "video-icon-with-background.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "video-icon.png";
						}else{
							obj.thumbIconPathN_str = self.gridSkinPath_str + "video-icon.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "video-icon-with-background.png";
						}
						
					}else if(/\.mp3/i.test(obj.type_str)){
						obj.type_str = FWDVUGP.AUDIO;
						obj.iconType_str = FWDVUGP.AUDIO;
						if(self.inverseButtonsIcons_bl){
							obj.thumbIconPathN_str = self.gridSkinPath_str + "audio-icon-with-background.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "audio-icon.png";
						}else{
							obj.thumbIconPathN_str = self.gridSkinPath_str + "audio-icon.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "audio-icon-with-background.png";
						}
					}else if(/\.swf/i.test(obj.type_str)){
						obj.type_str = FWDVUGP.FLASH;
						obj.iconType_str = FWDVUGP.FLASH;
						if(self.inverseButtonsIcons_bl){
							obj.thumbIconPathN_str = self.gridSkinPath_str + "flash-icon-with-background.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "flash-icon.png";
						}else{
							obj.thumbIconPathN_str = self.gridSkinPath_str + "flash-icon.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "flash-icon-with-background.png";
						}
					}else if(/youtube\.|vimeo\./i.test(obj.type_str)){
						if(obj.type_str.indexOf("youtube.") != -1){
							obj.iconType_str = FWDVUGP.YOUTUBE;
							if(self.inverseButtonsIcons_bl){
								obj.thumbIconPathN_str = self.gridSkinPath_str + "youtube-icon-with-background.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "youtube-icon.png";
							}else{
								obj.thumbIconPathN_str = self.gridSkinPath_str + "youtube-icon.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "youtube-icon-with-background.png";
							}
						}else{
							obj.iconType_str = FWDVUGP.VIMEO;
							if(self.inverseButtonsIcons_bl){
								obj.thumbIconPathN_str = self.gridSkinPath_str + "vimeo-icon-with-background.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "vimeo-icon.png";
							}else{
								obj.thumbIconPathN_str = self.gridSkinPath_str + "vimeo-icon.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "vimeo-icon-with-background.png";
							}
						}
						obj.type_str = FWDVUGP.IFRAME;
					}else if(/link:/i.test(obj.type_str)){
						obj.url = obj.url.substr(5);
						obj.target = obj.target;
						obj.iconType_str = FWDVUGP.LINK;
						if(self.inverseButtonsIcons_bl){
							obj.thumbIconPathN_str = self.gridSkinPath_str + "link-icon-with-background.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "link-icon.png";
						}else{
							obj.thumbIconPathN_str = self.gridSkinPath_str + "link-icon.png";
							obj.thumbIconPathS_str = self.gridSkinPath_str + "link-icon-with-background.png";
						}
						obj.type_str = FWDVUGP.LINK;
					}else{
						if(obj.type_str.indexOf("google.") != -1){
							obj.iconType_str = FWDVUGP.MAPS;
							if(self.inverseButtonsIcons_bl){
								obj.thumbIconPathN_str = self.gridSkinPath_str + "maps-icon-with-background.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "maps-icon.png";
							}else{
								obj.thumbIconPathN_str = self.gridSkinPath_str + "maps-icon.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "maps-icon-with-background.png";
							}
						}else{
							obj.iconType_str = FWDVUGP.IFRAME;
							if(self.inverseButtonsIcons_bl){
								obj.thumbIconPathN_str = self.gridSkinPath_str + "iframe-icon-with-background.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "iframe-icon.png";
							}else{
								obj.thumbIconPathN_str = self.gridSkinPath_str + "iframe-icon.png";
								obj.thumbIconPathS_str = self.gridSkinPath_str + "iframe-icon-with-background.png";
							}
						}
						obj.type_str = FWDVUGP.IFRAME;
					}
					
					if(obj.type_str == FWDVUGP.IMAGE_TYPE || obj.type_str == FWDVUGP.VIDEO_TYPE){
						var firstUrlPath = encodeURI(obj.url.substr(0,obj.url.lastIndexOf("/") + 1));
						var secondUrlPath = encodeURIComponent(obj.url.substr(obj.url.lastIndexOf("/") + 1));
						obj.url = firstUrlPath + secondUrlPath;
					}
					self.parsedPlaylist_ar.push(obj);
					
				}
				
				
				self.categories_ar[j] = FWDVRLUtils.getAttributeValue(allPlaylists_ar[j], "data-category-name");
			}
			
			self.finalizePlaylist();
			
			try{
				self.playListElement.parentNode.removeChild(self.playListElement);
			}catch(e){};
		};
		
		
		this.finalizePlaylist = function(){
			
			var lightboxParsedPlaylist_ar = [];
			self.playlist_ar = {playlistItems:self.parsedPlaylist_ar};
			
			if(self.randomizeCategories_bl) self.playlist_ar.playlistItems = FWDVRLUtils.randomizeArray(self.playlist_ar.playlistItems);
			
			for(var i=0; i<self.playlist_ar.playlistItems.length; i++){
				if(self.playlist_ar.playlistItems[i].type_str != FWDVUGP.LINK 
				   && self.playlist_ar.playlistItems[i].type_str != FWDVUGP.NONE){
					lightboxParsedPlaylist_ar.push(self.playlist_ar.playlistItems[i]);
				}
			}
			
			if(self.showAllCategories_bl){
				self.categories_ar.splice(0,0, self.allCategoriesLabel_str);
			}
			
			self.catsLength_ar = [];
			for (var i=0; i<self.categories_ar.length; i++){
				self.catsLength_ar[i] = 0;
			}
			
			for (var i=0; i< self.playlist_ar.playlistItems.length; i++){
				if(self.showAllCategories_bl){
					self.catsLength_ar[0]++;
					self.catsLength_ar[self.playlist_ar.playlistItems[i].catId + 1]++;
				}else{
					self.catsLength_ar[self.playlist_ar.playlistItems[i].catId]++;
				}
			}
			
			self.lightboxPlaylist_ar = {playlistItems:lightboxParsedPlaylist_ar};
		};
		
		//####################################//
		/* Prepare skin for loading */
		//####################################//
		this.prepareSiknForLoading = function(){
			self.loadMainSkin_bl = true;
			self.mainPreloader_img = new Image();
			self.mainPreloader_img.onerror = self.onSkinLoadErrorHandler;
			self.mainPreloader_img.onload = self.onPreloaderLoadHandler;
			self.mainPreloader_img.src = self.gridSkinPath_str + "preloader.png";
			
			self.skinPaths_ar = [
			     {img:self.fullScreenN_img = new Image(), src:self.gridSkinPath_str + "full-screen-normal.png"},    
			     {img:self.normalScreenN_img = new Image(), src:self.gridSkinPath_str + "normal-screen-normal.png"}
			];
			
			self.fullScreenSPath_str = self.gridSkinPath_str + "full-screen-selected.png";
			self.normalScreenSPath_str = self.gridSkinPath_str + "normal-screen-selected.png";
			
			//if(self.showHelpScreen_bl){
				//self.skinPaths_ar.push(
				   // {img:self.helpScreen_img = new Image(), src:self.gridSkinPath_str + self.helpScreenPath_str},
				   // {img:self.okButtonN_img = new Image(), src:self.gridSkinPath_str + "ok-button.png"}
				//);
			//};
			self.loadMoreSPath_str = self.gridSkinPath_str + "load-more-button-over.png";
			self.handGrabPath_str = self.gridSkinPath_str + "handgrab.cur";
			self.handMovePath_str = self.gridSkinPath_str + "handmove.cur";
			
			self.totalGraphics = self.skinPaths_ar.length;
		};
		
		//####################################//
		/* Preloader load done! */
		//###################################//
		this.onPreloaderLoadHandler = function(){
			setTimeout(function(){
				self.dispatchEvent(FWDVUGPData.PRELOADER_LOAD_DONE);
				if(self.isFacebook_bl){
					self.setupFacebook(true);
				}else{
					self.loadPlaylist();
				}
			}, 50);
		};
		
		//####################################//
		/* load buttons graphics */
		//###################################//
		self.loadSkin = function(){
			var img;
			var src;
			
			for(var i=0; i<self.totalGraphics; i++){
				img = self.skinPaths_ar[i].img;
				src = self.skinPaths_ar[i].src;
				img.onload = self.onSkinLoadHandler;
				img.onerror = self.onSkinLoadErrorHandler;
				img.src = src;
			}
		};
		
		this.onSkinLoadHandler = function(e){
			self.countLoadedSkinImages++;
			if(self.countLoadedSkinImages == self.totalGraphics){
				setTimeout(function(){
					self.dispatchEvent(FWDVUGPData.LOAD_DONE);
				}, 50);
			}
		};
		
		self.onSkinLoadErrorHandler = function(e){
			if (FWDVRLUtils.isIEAndLessThen9){
				message = "Graphics image not found!";
			}else{
				message = "The skin graphics with label <font color='#FF0000'>" + e.target.src + "</font> can't be loaded, check path!";
			}
			
			if(window.console) console.log(e);
			var err = {text:message};
			setTimeout(function(){
				self.dispatchEvent(FWDVUGPData.LOAD_ERROR, err);
			}, 50);
		};
	
	
		this.init();
	};
	
	/* set prototype */
	FWDVUGPData.setPrototype = function(){
		FWDVUGPData.prototype = new FWDVRLEventDispatcher();
	};
	
	FWDVUGPData.isSoundCloud_bl = false;
	FWDVUGPData.isFaceBook_bl = false;
	FWDVUGPData.prototype = null;
	FWDVUGPData.PRELOADER_LOAD_DONE = "onPreloaderLoadDone";
	FWDVUGPData.LOAD_DONE = "onLoadDone";
	FWDVUGPData.LOAD_ERROR = "onLoadError";
	FWDVUGPData.LIGHBOX_CLOSE_BUTTON_LOADED = "onLightBoxCloseButtonLoadDone";
	
	window.FWDVUGPData = FWDVUGPData;
}(window));