/* FWDVUGPMenu */
(function (window){
	
	var FWDVUGPMenu = function(data, parent){
		
		var self = this;
		var prototype = FWDVUGPMenu.prototype;
		
		this.categories_ar = data.categories_ar;
		this.buttons_ar = [];
		this.buttonsOriginal_ar = [];
		this.spacers_ar = [];
		this.catId_ar =  data.startAtCategory_ar;
		this.catsLength_ar = data.catsLength_ar;
	
		
		this.allCategoriesButton_do;
		
		this.buttonsHolder_do;
		this.searchButton_do;
		
		this.searchLabel_str = data.searchLabel_str;
		this.comboboxSelectorLabel_str = data.comboboxSelectorLabel_str;
		this.menuPosition_str = data.menuPosition_str;
		this.menuBackgroundClass_str = data.menuBackgroundClass_str;
		this.menuButtonSpacerColor_str = data.menuButtonSpacerColor_str;
		this.menuButtonsSpacersClassName_str = data.menuButtonsSpacersClassName_str;
		this.menuType_str = data.menuType_str;
		this.comboboxArrowNormalColor_str = data.comboboxArrowNormalColor_str;
		this.comboboxArrowSelectedColor_str = data.comboboxArrowSelectedColor_str;
		
		this.menuButtonSpacerWidth = data.menuButtonSpacerWidth;
		this.menuButtonSpacerHeight = data.menuButtonSpacerHeight;
		
		this.curId = this.catId_ar[0];
		this.menuItemBorderSize = 0;
		this.menuButtonsSapcerLeftAndRight = data.menuButtonsSapcerLeftAndRight;
		this.menuMaxWidth = data.menuMaxWidth;
		this.menuOffsetTop = data.menuOffsetTop;
		this.menuOffsetBottom = data.menuOffsetBottom;
		this.horizontalSpaceBetweenMenuButtons = data.horizontalSpaceBetweenMenuButtons;
		this.verticalSpaceBetweenMenuButtons = data.verticalSpaceBetweenMenuButtons;
		this.totalButtons = self.categories_ar.length;
		this.selectorOriginalWidth = 0;
		this.stageWidth = 0;
		this.stageHeight = 0;
		
		this.isComboboxShowed_bl = false;
		this.showTotalThumbnailsPerCategory_bl = data.showTotalThumbnailsPerCategory_bl;
		this.showAllCategories_bl = data.showAllCategories_bl;
		this.showAllCategories2_bl = false;
		this.multipleCategorySelection_bl = data.multipleCategorySelection_bl;
		this.showMenuButtonsSpacers_bl = data.showMenuButtonsSpacers_bl;
		this.isShowed_bl = data.showMenu_bl;
		this.isMobile_bl = FWDVRLUtils.isMobile;
		this.hasPointerEvent_bl = FWDVRLUtils.hasPointerEvent;
		this.showSearchButton_bl = data.showSearchButton_bl;

		this.init = function(){
			this.getStyle().backgroundColor = "";
			this.screen.className = this.menuBackgroundClass_str;
			
			if(FWDVIGP != "undefined") this.setupSearch();
			if(FWDVIGP) this.showSearchButton_bl = false;
			this.setupButtons();
			this.setButtonsLabels(this.showTotalThumbnailsPerCategory_bl);
			this.setButtons(this.catId_ar[0]);
			this.setupSpacers();
			this.setupCombobox();
			this.updateMenuStyle();
			this.setAlpha(0);
			
			setTimeout(function(){
				self.resizeAndPosition();
				if(FWDVIGP){
					FWDAnimation.to(self, .8, {alpha:1, delay:.3, ease:Expo.easeOut});
				}else{
					FWDAnimation.to(self, .8, {alpha:1, ease:Expo.easeOut});
				}
				
			}, 80);
		};
		
		//#######################################//
		/* Resize and position */
		//#######################################//
		this.resizeAndPosition = function(){
			
			self.stageWidth = parent.stageWidth;
			if(!self.isShowed_bl || self.stageWidth == 0) return;
			self.positionButtons();
			
			self.setWidth(self.stageWidth);
			self.setHeight(self.stageHeight);
		};
		
		//#######################################//
		/* Setup combobox holders */
		//#######################################//
		this.setupCombobox = function(){
			
			this.mainButtonsHolder_do = new FWDVRLDisplayObject("div");
			this.buttonsHolder_do = new FWDVRLDisplayObject("div");
			this.buttonsHolder_do.setX(-1000);
			
			this.arrow_do = new FWDVRLTransformDisplayObject("div");
			this.arrow_do.setOverflow("visible");
			this.arrow_do.setDisplay("inline-block");
			this.arrow_do.getStyle().fontSmoothing = "antialiased";
			this.arrow_do.getStyle().webkitFontSmoothing = "antialiased";
			this.arrow_do.getStyle().textRendering = "optimizeLegibility";
			this.arrow_do.getStyle().whiteSpace = "nowrap";
			this.arrow_do.setBackfaceVisibility();
			this.arrow_do.getStyle().padding = "";
			this.arrow_do.getStyle().margin = "";
			this.arrow_do.getStyle().borderRight = "1px solid";
			this.arrow_do.getStyle().borderBottom = "1px solid";
			this.arrow_do.setWidth(10);
			this.arrow_do.setHeight(10);
			this.arrow_do.getStyle().borderColor = this.comboboxArrowNormalColor_str;
			
			FWDVUGPMenuButton.setPrototype();
			this.selector_do = new FWDVUGPMenuButton(
				"NOT DEFINED",
				data.comboboxSelectorBackgroundNormalClassName_str,
				data.comboboxSelectorBackgroundSelectedClassName_str,
				data.comboboxSelectorTextNormalClassName_str,
				data.comboboxSelectorTextSeectedClassName_str,
				10
			);
			
			this.selector_do.addListener(FWDVUGPMenuButton.MOUSE_OVER, self.selectorOverHandler);
			this.selector_do.addListener(FWDVUGPMenuButton.MOUSE_OUT, self.selectorOutHandler);
			
			if(!FWDVRLUtils.isIEAndLessThen9) this.selector_do.addChild(this.arrow_do);
			this.selector_do.addListener(FWDVUGPMenuButton.MOUSE_UP, this.openCombobox);
			this.selector_do.setLabel(self.comboboxSelectorLabel_str);
			this.selector_do.setSize();
			
			setTimeout(function(){
				self.selector_do.getStyle().width = (self.selector_do.getWidth() + 40) + "px";
				self.selectorOriginalWidth = self.selector_do.getWidth();
				
				self.arrow_do.setRotation(-135);
				self.arrow_do.setY(parseInt(self.selector_do.h - self.arrow_do.h)/2 + 3 - self.menuItemBorderSize);
			}, 60);
			
			this.addChild(this.mainButtonsHolder_do);
			this.mainButtonsHolder_do.addChild(this.buttonsHolder_do);
			this.mainButtonsHolder_do.addChild(this.selector_do);
		};
		
		this.selectorOverHandler = function(){
			FWDAnimation.to(self.arrow_do.screen, .8, {borderColor:self.comboboxArrowSelectedColor_str, ease:Expo.easeOut});
		};
		
		this.selectorOutHandler = function(){
			FWDAnimation.to(self.arrow_do.screen, .8, {borderColor:self.comboboxArrowNormalColor_str, ease:Expo.easeOut});
		};
		
		this.openCombobox = function(){
			if(self.isComboboxShowed_bl) return
			self.isComboboxShowed_bl = true;
		
			if(parent.zIndex == 0){
				self.getStyle().zIndex = 1;
			}else{
				self.getStyle().zIndex = parent.zIndex + 1;
			}
		
			self.selector_do.isSelected_bl = self.selector_do.isDisabled_bl = true;
			self.buttonsHolder_do.setX(0);
			self.buttonsHolder_do.setY(-self.buttonsHolder_do.h + self.selector_do.h);
			self.mainButtonsHolder_do.setHeight(self.buttonsHolder_do.h + self.mainButtonsHolder_do.h);
			FWDAnimation.to(self.buttonsHolder_do, .8, {y:self.selector_do.h, ease:Expo.easeInOut});
			FWDAnimation.to(self.arrow_do, .8, {rotation:45, y:parseInt(self.selector_do.h - self.arrow_do.h)/2 - 3 - self.menuItemBorderSize, ease:Expo.easeInOut});
			
			self.startToCheckMenuHit();
		};
		
		this.closeComboBox = function(){
			if(FWDAnimation.isTweening(self.mainButtonsHolder_do)) return
			
			self.selector_do.isSelected_bl = self.selector_do.isDisabled_bl = false;
			self.selector_do.setNormalState(true);
			
			FWDAnimation.to(self.buttonsHolder_do, .8, {y:-self.buttonsHolder_do.h + self.selector_do.h, ease:Expo.easeInOut});
			FWDAnimation.to(self.mainButtonsHolder_do, .8, {h:self.selector_do.h, ease:Expo.easeInOut, onComplete:function(){self.isComboboxShowed_bl = false;}});
			
			FWDAnimation.to(self.arrow_do, .8, {rotation:-135, y:parseInt(self.selector_do.h - self.arrow_do.h)/2 + 3 - self.menuItemBorderSize, ease:Expo.easeInOut});
			FWDAnimation.to(self.arrow_do.screen, .8, {borderColor:self.comboboxArrowNormalColor_str, ease:Expo.easeOut, onComplete:function(){
				self.buttonsHolder_do.setX(-1000);
				self.getStyle().zIndex = "auto";
			}});
		};
		
		this.startToCheckMenuHit = function(){
			if(this.isCheckHitAdded_bl) return;
			this.isCheckHitAdded_bl = true;
			
			if(self.isMobile_bl){
				setTimeout(function(){
					if(FWDVRLUtils.isIOS){
						self.hitThhumbnailId_to = window.addEventListener("touchstart", self.checkThumbnailHit);
					}else{
						self.hitThhumbnailId_to = window.addEventListener("click", self.checkThumbnailHit);
					}
				}, 50);
			}else{
				if(window.addEventListener){
					window.addEventListener("mousemove", self.checkThumbnailHit);
					window.addEventListener("mousedown", self.chechThumbnailsOnClick);
				}else{
					document.attachEvent("onmousemove", self.checkThumbnailHit);
					document.attachEvent("onmousedown", self.chechThumbnailsOnClick);
				}
			}
		};
		
		this.stopToCheckMenuHit = function(){
			if(!self.isCheckHitAdded_bl) return;
			self.isCheckHitAdded_bl = false;
		
			if(self.isMobile_bl){
				if(FWDVRLUtils.isIOS){
					self.hitThhumbnailId_to = window.removeEventListener("touchstart", self.checkThumbnailHit);
				}else{
					self.hitThhumbnailId_to = window.removeEventListener("click", self.checkThumbnailHit);
				}
			}else{
				if(window.removeEventListener){
					window.removeEventListener("mousemove", self.checkThumbnailHit);
					window.removeEventListener("mousedown", self.chechThumbnailsOnClick);
				}else{
					document.detachEvent("onmousemove", self.checkThumbnailHit);
					document.detachEvent("onmousedown", self.chechThumbnailsOnClick);
				}
			}
			
			clearTimeout(self.hitThhumbnailId_to);
		};
		
		this.chechThumbnailsOnClick = function(e){
			var vc = FWDVRLUtils.getViewportMouseCoordinates(e);	
			if(!FWDVRLUtils.hitTest(self.mainButtonsHolder_do.screen, vc.screenX, vc.screenY)){
				clearTimeout(self.hideComoboboxWithDelayId_to);
				self.stopToCheckMenuHit();
				self.closeComboBox();	
			}
		};
		
		this.checkThumbnailHit = function(e){
			var vc = FWDVRLUtils.getViewportMouseCoordinates(e);	
			if(FWDVRLUtils.hitTest(self.mainButtonsHolder_do.screen, vc.screenX, vc.screenY)){
				clearTimeout(self.hideComoboboxWithDelayId_to);
			}else{
				clearTimeout(self.hideComoboboxWithDelayId_to);
				self.hideComoboboxWithDelayId_to = setTimeout(function(){
					self.stopToCheckMenuHit();
					self.closeComboBox();	
				}, 200);
				
			}
		};
		
		//#######################################//
		/* Setup search */
		//#######################################//
		this.setupSearch = function(){
			FWDVUGPMenuButton.setPrototype();
			this.searchButton_do = new FWDVUGPMenuButton(
				this.searchLabel_str,
				data.searchClassName_str,
				data.menuButtonBackgroundSelectedClassName_str,
				data.searchClassName_str,
				data.menuButtonTextSeectedClassName_str,
				100);
			
			this.addChild(this.searchButton_do);
			this.searchButton_do.setLabel(this.searchLabel_str);
			this.searchButton_do.setSize();
			if(!this.showSearchButton_bl) this.searchButton_do.setVisible(false);
			this.searchButton_do.addListener(FWDVUGPMenu.SEARCH, this.searchHandler);
			
		};
		
		this.searchHandler = function(e){
			self.dispatchEvent(FWDVUGPMenu.SEARCH, {searchValue:e.param});
		};
		
		
		//#######################################//
		/* Setup buttons */
		//#######################################//
		this.setupButtons = function(){
			var button;
			var label_str;
			
			for(var i=0; i<this.totalButtons; i++){
			
				FWDVUGPMenuButton.setPrototype();
				button = new FWDVUGPMenuButton(
					label_str,
					data.menuButtonBackgroundNormalClassName_str,
					data.menuButtonBackgroundSelectedClassName_str,
					data.menuButtonTextNormalClassName_str,
					data.menuButtonTextSeectedClassName_str,
					i
				);
				
				if(i == 0) this.allCategoriesButton_do = button;
				
				button.addListener(FWDVUGPMenuButton.MOUSE_UP, this.buttonOnMouseUpHandler);
				
				this.buttons_ar.push(button);
				this.buttonsOriginal_ar.push(button);
			}
			
			if(this.showSearchButton_bl){
				this.buttons_ar.push(this.searchButton_do);
				this.buttonsOriginal_ar.push(this.searchButton_do);
			}
		};
		
		this.buttonOnMouseUpHandler = function(e){
			if(parent.thumbsManager_do && parent.thumbsManager_do.isCategoryChanging_bl) return;
			if(e){
				self.setButtons(e.id);
				self.curId = e.id;
			}
			
			if(FWDVIGP){
				var offset = self.showAllCategories2_bl ? 1 : 0;
				self.dispatchEvent(FWDVUGPMenu.MOUSE_UP, {id:e.id + offset});
				if(self.menuType_str ==  "combobox") self.closeComboBox();
			}else{
				self.dispatchEvent(FWDVUGPMenu.MOUSE_UP, {id:self.getIdsArray()});
			}
		};
		
		this.resetButtonsIGP = function(){
			if(!this.showAllCategories_bl && this.curId == 0){
				this.buttons_ar[0].setSelected();
				self.dispatchEvent(FWDVUGPMenu.MOUSE_UP, {id:1});
			}
			
			for(var i=0; i<this.buttons_ar.length; i++){
				button = this.buttons_ar[i];
				button.id = i;
			}
			
			
			if(this.menuType_str ==  "list"){
				this.addChild(self.buttons_ar[0]);
			}else{
				this.buttonsHolder_do.addChild(self.buttons_ar[0]);
			}
		};
		
		this.setButtonsLabels = function(showTotalNumbersPerCategory_bl){
			var button;
			
			for(var i=0; i<this.buttonsOriginal_ar.length; i++){
				button = this.buttonsOriginal_ar[i];
				if(button != this.searchButton_do){
					button.w = 0;
					button.getStyle().width = "auto";
				}
				
				if(showTotalNumbersPerCategory_bl){
					label_str = this.categories_ar[i] + " (" + this.catsLength_ar[i] + ")";
				}else{
					label_str = this.categories_ar[i];
				}
				
				
				if(button != this.searchButton_do){
					if(this.categories_ar[i] != undefined) button.setLabel(label_str);
					button.setSize();
				}
			}
		};
		
		this.setButtons = function(id){
			var button;
			var countSelectedButtons = 0;
			
			button = this.buttons_ar[id];
			
			if(this.multipleCategorySelection_bl){
				if(this.multipleCategorySelection_bl){
					if(button.isSelectedFinal_bl){
						button.setUnselected();
					}else{
						button.setSelected();
					}
				}
				
				for(var i=0; i<this.totalButtons; i++){
					button = this.buttons_ar[i];
					if(button.isSelectedFinal_bl) countSelectedButtons++;
					if(this.showAllCategories_bl && id == 0){
						if(i != 0) button.setUnselected();
					}else if(this.showAllCategories_bl && id != 0){
						this.buttons_ar[0].setUnselected();
					}
				}
				
				button = this.buttons_ar[id];
				if(countSelectedButtons == 0) button.setSelected();
			}else{
				var button;
				for (var i=0; i<self.totalButtons; i++){	
					button = self.buttons_ar[i];
					if(i == id){
						button.isSelectedFinal_bl = true;
						button.disable();
					}else{
						button.isSelectedFinal_bl = false;
						button.enable();
					}
				}
			}
		};
		
		this.resetButtonsState = function(){
			var button;
			var fistButton_bl = true;
					
			if(!self.multipleCategorySelection_bl){
				
				if(self.allCategoriesButton_do.isSelectedFinal_bl && self.buttons_ar[0].id == 1){
					self.buttons_ar[0].isSelectedFinal_bl = true;
				}
				
				for (var i=0; i<self.totalButtons; i++){
					button = self.buttons_ar[i];
					button.id = i;
					
					if(button.isSelectedFinal_bl && fistButton_bl){
						button.isDisabled_bl = false;
						button.disable();
						fistButton_bl = false;
					}else{
						button.isSelectedFinal_bl = false;
						button.isSelected_bl = false;
						button.isDisabled_bl = true;
						button.enable();
					}
				}	
				return;
			}
			
			
			if(this.showAllCategories_bl){
				for (var i=0; i<self.totalButtons; i++){	
					button = self.buttons_ar[i];
					button.id = i;	
					button.isDisabled_bl = true;
					button.enable();
					if(button.isSelectedFinal_bl) button.setSelectedState();
				}	
				
				
				if(this.catId_ar.length == 1 && this.catId_ar[0] == 0){
					this.buttons_ar[1].isSelectedFinal_bl = false;
					this.setButtons(1);
				}
				
				/*
				else if(this.catId_ar.length == 1 && this.buttons_ar[this.catId_ar[0]].isSelected_bl){
					this.buttons_ar[this.catId_ar[0]].setSelectedState();
				}
				*/ 
			}else{
				
				if(self.catId_ar.length == 0){
					self.catId_ar[0] = [0];
				}
				
				for (var i=0; i<self.totalButtons; i++){
					button = self.buttons_ar[i];
					button.id = i;
					
					if(i == self.catId_ar[i]){
						button.isSelectedFinal_bl = true;
						button.isDisabled_bl = true;
						button.enable();
						button.setSelectedState();
					}
				}	
				
			}
		};
		
		this.getIdsArray = function(){
			self.catId_ar = [];
			
			for(var i=0; i<self.totalButtons; i++){
				button = self.buttons_ar[i];
				if(button.isSelectedFinal_bl || button.isDisabled_bl) self.catId_ar.push(button.id);
			}
			
			return self.catId_ar;
		};
	
		//###############################################//
		/* Update menu style */
		//###############################################//
		this.updateMenuStyle = function(){
			var spacer;
			if(this.menuType_str ==  "list"){
				for(var i=0; i<this.totalButtons; i++){
					button = this.buttons_ar[i];
					this.addChild(button);
					spacer = this.spacers_ar[i];
					
					spacer.setHeight(this.menuButtonSpacerHeight);
					spacer.setWidth(1);
					this.addChild(spacer);
					if(i == this.totalButtons - 1) spacer.setVisible(false);
				}
				this.selector_do.setVisible(false);
			}else{
				for(var i=0; i<this.totalButtons; i++){
					button = this.buttons_ar[i];
					this.buttonsHolder_do.addChild(button);
					spacer = this.spacers_ar[i];
					spacer.setHeight(1);
					this.buttonsHolder_do.addChild(spacer);
					if(i == this.totalButtons - 1) spacer.setVisible(true);
				}
				this.selector_do.setVisible(true);
			}
			this.positionButtons();
			this.setHeight(this.stageHeight);
		};
		
		//###############################################//
		/* Set buttons class */
		//###############################################//
		this.setButtonsClass = function(
			backgroundNormalClassName,
			backgroundSelectedClassName,
			textNormalClassName,
			textSelectedClassName,
			selectorBackgroundNormalClassName,
			selectorBackgroundSelectedClassName,
			selectorTextNormalClassName,
			selectorTextSelectedClassName,
			spacerClassName,
			searchBoxClassName,
			arrowNormalColor,
			arrowSelectedColor
		){
			var button;
			this.selectorOriginalWidth = 0;
			this.comboboxArrowNormalColor_str  = arrowNormalColor;
			this.comboboxArrowSelectedColor_str = arrowSelectedColor;
			
			this.arrow_do.getStyle().borderColor = this.comboboxArrowNormalColor_str;			
			
			for(var i=0; i<self.buttonsOriginal_ar.length; i++){
				button = self.buttonsOriginal_ar[i];
				
				if(button != this.searchButton_do){
					button.w = 0;
					button.getStyle().width = "0px";
					button.getStyle().width = "auto";
					button.setClass(backgroundNormalClassName, backgroundSelectedClassName, textNormalClassName, textSelectedClassName);
					button.setSize();
				}
				
				if(button == this.searchButton_do){
					button.w = 0;
					this.searchButton_do.getStyle().width = "0px";
					this.searchButton_do.getStyle().width = "auto";
					this.searchButton_do.setClass("", "", searchBoxClassName, "");
					this.searchButton_do.setSize();
				}
			}
			
			
			this.selector_do.getStyle().width = "auto";
			this.selector_do.setClass(selectorBackgroundNormalClassName, selectorBackgroundSelectedClassName, selectorTextNormalClassName, selectorTextSelectedClassName);
			this.selector_do.setSize();
			
			setTimeout(function(){
				self.selector_do.getStyle().width = (self.selector_do.getWidth() + 40) + "px";
				self.selectorOriginalWidth = self.selector_do.getWidth();
				self.arrow_do.setY(parseInt(self.selector_do.h - self.arrow_do.h)/2 + 3 - self.menuItemBorderSize);
			}, 51);
			
			for(var i=0; i<self.totalButtons; i++){
				spacer = this.spacers_ar[i];
				spacer.screen.className = spacerClassName;
			}
		};
		
		//###################################################//
		/*setup spacers */
		//###################################################//
		this.setupSpacers = function(){
			var spacer;
			var offsetTotalButtons = 0;
			
			for(var i=0; i<self.totalButtons; i++){
				spacer = new FWDVRLDisplayObject("div");
				this.spacers_ar[i] = spacer;
				spacer.setWidth(this.menuButtonSpacerWidth);
				spacer.setHeight(this.menuButtonSpacerHeight);
				spacer.getStyle().backgroundColor = "";
				spacer.screen.className = this.menuButtonsSpacersClassName_str;
				if(!this.showMenuButtonsSpacers_bl) spacer.setVisible(false);
				self.addChild(spacer);
			}
		};
		
		this.showOrHideSpacers = function(show_bl){
			this.showMenuButtonsSpacers_bl = show_bl;
			for(var i=0; i<self.totalButtons; i++){
				spacer = this.spacers_ar[i];
				
				if(show_bl){
					spacer.setVisible(true);
					if(this.menuType_str ==  "list"){
						spacer.setHeight(this.menuButtonSpacerHeight);
						spacer.setWidth(1);
						if(i == this.totalButtons - 1) spacer.setVisible(false);
					}else{
						spacer.setHeight(1);
					}
				}else{
					spacer.setVisible(false);
					spacer.setY(-200);
					
				}
			}
		};
		
		//########################################//
		/* Show / hide search box */
		//########################################//
		this.showOrHideSearchBox = function(param){
			self.showSearchButton_bl = param;
			if(param){
				this.searchButton_do.setVisible(true);
			}else{
				this.searchButton_do.setVisible(false);
			}
		};
		
		//########################################//
		/* Position buttons */
		//########################################//
		this.positionButtons = function()
		{
			if(self.stageWidth == 0) return;
			
			var button;
			var prevButton;
			var rows_ar = [];
			var rowsWidth_ar = [];
			var stageWidth = self.stageWidth;
			var tempX = 0;
			var tempY = self.menuOffsetTop;
			var maxY = 0;
			var totalRowWidth = 0;
			var rowsNr = 0;
			var spacerCount = 0;
			var startX = 0;
			var greaterButtonWidth = this.selectorOriginalWidth;
			if(greaterButtonWidth == 0 && self.menuType_str == "combobox") return;
			
			var offsetButtonY = 0;
			
			if(stageWidth > self.menuMaxWidth){
				stageWidth = self.menuMaxWidth;
			}
			
			if(self.menuType_str == "combobox"){
				this.mainButtonsHolder_do.setY(this.menuOffsetTop);
				
				maxY = self.menuOffsetTop;
				
				if(!FWDVRLUtils.isIEAndLessThen9){
					self.menuItemBorderSize = getComputedStyle(self.buttons_ar[0].screen,null).getPropertyValue('border-left-width') || "0";
					self.menuItemBorderSize = parseInt(self.menuItemBorderSize.replace("px", ""));
				}
				
				for (var i=0; i<self.totalButtons; i++){	
					button = self.buttons_ar[i];
					if(button.w >= greaterButtonWidth){
						greaterButtonWidth = button.w;
					}
				}
			
				for (var i=0; i<self.totalButtons; i++){	
					
					button = self.buttons_ar[i];
					if(this.showMenuButtonsSpacers_bl){
						spacer = self.spacers_ar[i];
						spacer.setX(0);
						spacer.setWidth(greaterButtonWidth);
						spacer.setY(i * (spacer.h + button.h));
						button.setY( i * (spacer.h + button.h) + spacer.h);
					}else{
						button.setY(i * button.h);
					}
					
					button.setX(0);
				
					if(greaterButtonWidth > 35) button.setWidth(greaterButtonWidth - self.menuItemBorderSize * 2);
				}
				
				if(this.selectorOriginalWidth < greaterButtonWidth + 10){
					this.selector_do.setWidth(greaterButtonWidth - self.menuItemBorderSize * 2);
				}
				
				this.buttonsHolder_do.setWidth(greaterButtonWidth);
				this.buttonsHolder_do.setHeight(button.y + button.h);
				this.mainButtonsHolder_do.setWidth(greaterButtonWidth);
				this.mainButtonsHolder_do.setHeight(button.h);
				this.arrow_do.setX(greaterButtonWidth - 23 - self.menuItemBorderSize * 2);
				this.arrow_do.setY(parseInt(self.selector_do.h - this.arrow_do.h)/2 + 3 - this.menuItemBorderSize);
				
				if(self.menuPosition_str == "center"){
					if(self.showSearchButton_bl){
						if(self.searchButton_do.w + greaterButtonWidth + self.menuButtonsSapcerLeftAndRight * 2 + self.horizontalSpaceBetweenMenuButtons <self.stageWidth){
							self.mainButtonsHolder_do.setX(parseInt(self.stageWidth - (self.searchButton_do.w + greaterButtonWidth + self.horizontalSpaceBetweenMenuButtons))/2);
							self.searchButton_do.setX(self.mainButtonsHolder_do.x + greaterButtonWidth + self.horizontalSpaceBetweenMenuButtons);
							self.searchButton_do.setY(self.menuOffsetTop);
						}else{
							self.mainButtonsHolder_do.setX(parseInt(self.stageWidth -  greaterButtonWidth)/2);
							self.searchButton_do.setX(parseInt(self.stageWidth - self.searchButton_do.w)/2);
							self.searchButton_do.setY(self.menuOffsetTop + button.h + self.verticalSpaceBetweenMenuButtons);
							maxY = self.searchButton_do.y;
						}
					}else{
						self.mainButtonsHolder_do.setX(parseInt(self.stageWidth - greaterButtonWidth)/2);
					}
				}else if(self.menuPosition_str == "left"){
					self.mainButtonsHolder_do.setX(Math.max(self.menuButtonsSapcerLeftAndRight, parseInt(self.stageWidth - self.menuMaxWidth)/2));
					if(self.showSearchButton_bl){
						if(self.searchButton_do.w + greaterButtonWidth + self.menuButtonsSapcerLeftAndRight * 2 + self.horizontalSpaceBetweenMenuButtons < self.stageWidth){
							//self.searchButton_do.setX(Math.min(self.stageWidth - self.menuButtonsSapcerLeftAndRight - self.searchButton_do.w, parseInt(self.stageWidth/2 + self.menuMaxWidth/2) - self.searchButton_do.w));
							self.searchButton_do.setX(self.stageWidth - Math.max(self.menuButtonsSapcerLeftAndRight, parseInt((self.stageWidth - self.menuMaxWidth)/2)) - self.searchButton_do.w);
							self.searchButton_do.setY(self.menuOffsetTop);
						}else{
							self.searchButton_do.setX(self.mainButtonsHolder_do.x);
							self.searchButton_do.setY(self.menuOffsetTop + button.h + self.verticalSpaceBetweenMenuButtons);
							maxY = self.searchButton_do.y;
						}
					}
				}else if(self.menuPosition_str == "right"){
					self.mainButtonsHolder_do.setX(Math.min(self.stageWidth - self.menuButtonsSapcerLeftAndRight - greaterButtonWidth, parseInt(self.stageWidth/2 + self.menuMaxWidth/2) - greaterButtonWidth));
					if(self.showSearchButton_bl){
						if(self.searchButton_do.w + greaterButtonWidth + self.menuButtonsSapcerLeftAndRight * 2 + self.horizontalSpaceBetweenMenuButtons < self.stageWidth){
							//self.searchButton_do.setX(Math.max(self.menuButtonsSapcerLeftAndRight, parseInt(self.stageWidth - self.menuMaxWidth)/2));
							self.searchButton_do.setX(Math.max(self.menuButtonsSapcerLeftAndRight, parseInt((self.stageWidth - self.menuMaxWidth)/2)));
							self.searchButton_do.setY(self.menuOffsetTop);
						}else{
							self.searchButton_do.setX(self.stageWidth - self.menuButtonsSapcerLeftAndRight - self.searchButton_do.w);
							self.searchButton_do.setY(self.menuOffsetTop + button.h + self.verticalSpaceBetweenMenuButtons);
							maxY = self.searchButton_do.y;
						}
					}
				}
			}else{
				rows_ar[rowsNr] = [0];
				rowsWidth_ar[rowsNr] = self.buttons_ar[0].w;
				
				for (var i=0; i<self.totalButtons; i++){
					button = self.buttons_ar[i];
					button.getStyle().width = "auto";
				}
				
				var offsetToTlaButtons = this.showSearchButton_bl ? 1 : 0;
				
				for (var i=1; i<self.totalButtons + offsetToTlaButtons; i++){
					button = self.buttons_ar[i];
					
					if(rowsWidth_ar[rowsNr] + button.w + self.horizontalSpaceBetweenMenuButtons > stageWidth - self.menuButtonsSapcerLeftAndRight * 2){	
						rowsNr++;
						rows_ar[rowsNr] = [];
						rows_ar[rowsNr].push(i);
						rowsWidth_ar[rowsNr] = button.w;
					}else{
						rows_ar[rowsNr].push(i);
						rowsWidth_ar[rowsNr] += button.w + self.horizontalSpaceBetweenMenuButtons;
					}
				}
			
			   if (self.showSearchButton_bl && (rowsNr == 0) && (self.menuPosition_str == "right")){
				   rowsWidth_ar[0] -= self.buttons_ar[self.totalButtons].w + self.horizontalSpaceBetweenMenuButtons;
			   }
				
				for (var i=0; i<rowsNr + 1; i++){
					if(self.menuPosition_str == "center"){
						startX = Math.max(self.menuButtonsSapcerLeftAndRight, parseInt((self.stageWidth - rowsWidth_ar[i])/2));
					}else if(self.menuPosition_str == "left"){
						startX = Math.max(self.menuButtonsSapcerLeftAndRight, parseInt((self.stageWidth - self.menuMaxWidth)/2));
					}else if(self.menuPosition_str == "right"){
						startX = Math.min(parseInt((self.stageWidth - rowsWidth_ar[i]) - (self.stageWidth - self.menuMaxWidth)/2), parseInt((self.stageWidth - rowsWidth_ar[i] - self.menuButtonsSapcerLeftAndRight)));
					}
					
					if (i > 0) tempY += button.h + self.verticalSpaceBetweenMenuButtons;
						
					for (var j=0; j<rows_ar[i].length; j++){
						button = self.buttons_ar[rows_ar[i][j]];
					
						spacer = self.spacers_ar[spacerCount];
						spacerCount ++;
					
						if (j == 0){
							tempX = startX;
						}else{
							prevButton = self.buttons_ar[rows_ar[i][j] - 1];
							tempX = prevButton.finalX + prevButton.w + self.horizontalSpaceBetweenMenuButtons;
						}
						
						if(spacer && self.showMenuButtonsSpacers_bl){
							if(j == rows_ar[i].length - 1){
								spacer.setX(-1000);
							}else{
								spacer.setX(parseInt(tempX + button.w + (self.horizontalSpaceBetweenMenuButtons - spacer.w)/2));
								spacer.setY(parseInt(tempY +(button.h - spacer.h)/2));
							}
						}
						
						button.finalX = tempX;
						button.finalY = tempY;
							
						if (maxY < button.finalY) maxY = button.finalY;
					
						button.setX(button.finalX);
						button.setY(button.finalY);
					}
				}
				
				if (self.showSearchButton_bl && (rowsNr == 0)){
					if (self.menuPosition_str == "left"){
						button = self.buttons_ar[self.totalButtons];
						button.setX(self.stageWidth - startX - button.w);
					}else if (self.menuPosition_str == "right"){
						button = self.buttons_ar[self.totalButtons];
						var leftX = Math.max(self.menuButtonsSapcerLeftAndRight, parseInt((self.stageWidth - self.menuMaxWidth)/2));
						button.setX(leftX);
					}
				}
			}
			
			self.stageHeight = maxY + self.buttons_ar[0].h + self.menuOffsetBottom;
		};
		
		this.init();
	};
	
	/* set prototype */
	FWDVUGPMenu.setPrototype = function(){
		FWDVUGPMenu.prototype = new FWDVRLDisplayObject("div", "relative", "visible");
	};
	
	FWDVUGPMenu.MOUSE_OVER = "onMouseOver";
	FWDVUGPMenu.MOUSE_OUT = "onMouseOut";
	FWDVUGPMenu.MOUSE_UP = "onMouseDown";
	FWDVUGPMenu.RIGHT = "right";
	FWDVUGPMenu.LEFT = "left";
	FWDVUGPMenu.BOTTOM = "bottom";
	FWDVUGPMenu.TOP = "top";
	
	FWDVUGPMenu.prototype = null;
	window.FWDVUGPMenu = FWDVUGPMenu;
}(window));