/* FWDVUGPVerticalThumbnailsManager */
(function (window){
	
	var FWDVUGPVerticalThumbnailsManager = function(data, parent){
		
		var self = this;
		var prototype = FWDVUGPVerticalThumbnailsManager.prototype;
		
		this.sourcePlaylist_ar = data.playlist_ar.playlistItems;
		this.dataThumbnails_ar = [];
		this.tempPlaylist_ar;
	
		this.columnHeights_ar = [];
		this.loadMoreCatsData_ar = [];
		this.catId_ar = data.startAtCategory_ar;
		
		this.loadMoreButton_do;
		
		this.curDataThumbnail;
		this.thumbnailLoadingType_str = data.thumbnailLoadingType_str;
		
		this.totalLoadedThumbnails = 0;
		this.loadMoreButtonOffsetTop = data.loadMoreButtonOffsetTop;
		this.loadMoreButtonOffsetBottom = data.loadMoreButtonOffsetBottom;
		this.thumbnailsPerSet = data.howManyThumbnailsToDisplayPerSet;
		this.thumbsHOffset = data.thumbnailsHorizontalOffset;
		this.thumbsVOffset = data.thumbnailsVerticalOffset;
		this.offsetTotalHeight = 0;
		this.maxH = 0;
		this.thumbOffsetX = 0;
		this.catId = data.startAtCategory;
		this.stageWidth = 0;
		this.prevStageWidth = 0;
		this.thumbnailMaxWidth = data.thumbnailMaxWidth;
		this.thumbnailMaxHeight = data.thumbnailMaxHeight;
		this.leftWidth = 0;
		this.thumbWidth;
		this.thumbHeight;
		this.thumbsHSpace = data.horizontalSpaceBetweenThumbnails;
		this.thumbsVSpace = data.verticalSpaceBetweenThumbnails;
		this.countLoadedThumbs = 0;
		this.borderSize = data.thumbnailBorderSize;
		this.totalThumbnails = this.sourcePlaylist_ar.length;
		this.tempTotalThumbnails = this.sourcePlaylist_ar.length;
		this.globalX = 0;
		this.globalY = 0;
		
		this.catChanging_to;
		this.arangeFaterTweenId_to;
		
		this.isLoadAtTheEnd_bl = false;
		this.isLoadMoreButtonShowed_bl = true;
		this.isCatChanging_bl = false;
		this.isFirstThumbnailLoaded_bl = false;
		this.firstThumbnailShowed_bl = false;
		this.animateParent_bl = data.animateParent_bl;
		
		this.showAllCategories_bl = data.showAllCategories_bl;
		this.totalCats = this.showAllCategories_bl ? data.categories_ar.length-1 : data.categories_ar.length;
		
		this.isMobile_bl = FWDVRLUtils.isMobile;
		
		
		//#######################################//
		/* initialize */
		//#######################################//
		this.init = function(){
			this.setOverflow("visible");
			this.setBkColor(parent.backgroundColor_str);
			this.setupThumbnailsData();
			if(self.thumbnailLoadingType_str == "loadmorewithbutton"){
				this.setupLoadMoreButton();
			}else if(this.thumbnailLoadingType_str == "loadmoreonscroll"){
				this.setupLoadMoreOnScroll();
			}
			
			this.filterCategories();
			this.startGetMousePosition();
			
		};
		
		//#######################################//
		/* Position and resize */
		//#######################################//
		this.resizeAndPosition = function(){
			self.stageWidth = parent.stageWidth;
			self.setDataForResize();
			self.positionThumbnailsAndMain();
		};
		
		//#######################################//
		/* Get mouse position */
		//#######################################//
		this.startGetMousePosition = function(){
			if(window.addEventListener){
				if(!self.isMobile_bl){
					window.addEventListener("touchstart", this.getMousePosition);
				}
				window.addEventListener("mousemove", this.getMousePosition);
			}else if(document.attachEvent){
				document.attachEvent("onmousemove", this.getMousePosition);
			}
		};
		
		this.getMousePosition = function(e){
			var mc = FWDVRLUtils.getViewportMouseCoordinates(e);
			if(!self.isMobile_bl){
				self.globalX = mc.screenX;
				self.globalY = mc.screenY;
			}
		};
		
		//#######################################//
		/* Setup thumbnails data */
		//#######################################//
		this.setupThumbnailsData = function(){
			var catsLength_ar = [];
			var obj;
			
			for (var i=0; i<this.totalThumbnails; i++){
				obj = {};
				obj.thumbnail = undefined;
				obj.id = i;
				obj.catId = this.sourcePlaylist_ar[i].catId;
				this.dataThumbnails_ar[i] = obj;
			}
			
			for (var i=0; i<this.totalCats; i++){
				catsLength_ar[i] = 0;
			}
			
			for (var i=0; i< this.totalThumbnails; i++){
				catsLength_ar[this.dataThumbnails_ar[i].catId]++;
			}

			
			for (var i=0; i<this.totalCats; i++){
				obj = {};
				obj.loaded = 0;
				obj.limit = 0;
				obj.total = catsLength_ar[i];
				obj.isSelected = false;
				
				this.loadMoreCatsData_ar[i] = obj;
			}
		};
	
		//#######################################//
		/* Setup thumbnails */
		//#######################################//
		this.getThumbnail =  function(catId, id){
			
			var props_obj = {};
			
			props_obj.parent = this;
			props_obj.id = id;
			props_obj.catId = catId;
			props_obj.presetType_str = data.presetType_str;
			props_obj.backgroundColor_str = data.thumbnailBackgroundColor_str;
			props_obj.borderNormalColor_str = this.sourcePlaylist_ar[id].thumbnailBorderNormalColor || data.thumbnailBorderNormalColor_str;
			props_obj.borderSelectedColor_str = this.sourcePlaylist_ar[id].thumbnailBorderSelectedColor || data.thumbnailBorderSelectedColor_str;
			props_obj.borderSize = data.thumbnailBorderSize;
			props_obj.borderRadius = data.thumbnailBorderRadius;
			props_obj.thumbnailOverlayColor_str = this.sourcePlaylist_ar[id].thumbnailOverlayColor || data.thumbnailOverlayColor_str;
			props_obj.thumbnailOverlayOpacity = data.thumbnailOverlayOpacity;
			props_obj.spaceBetweenTextAndIcons = data.spaceBetweenTextAndIcons;
			props_obj.extraButtonUrl_str = this.sourcePlaylist_ar[id].extraButtonUrl_str;
			props_obj.extraButtonUrlTarget_str = this.sourcePlaylist_ar[id].extraButtonUrlTarget_str;
			props_obj.thumbIconPathN_str = this.sourcePlaylist_ar[id].thumbIconPathN_str; 
			props_obj.thumbIconPathS_str = this.sourcePlaylist_ar[id].thumbIconPathS_str; 
			props_obj.thumbnailIconWidth = data.thumbnailIconWidth;
			props_obj.thumbnailIconHeight = data.thumbnailIconHeight;
			props_obj.linkIconPathN_str = data.linkIconPathN_str;
			props_obj.linkIconPathS_str = data.linkIconPathS_str;
			props_obj.spaceBetweenThumbanilIcons = data.spaceBetweenThumbanilIcons;
			props_obj.hideAndShowTransitionType_str = data.hideAndShowTransitionType_str;
			props_obj.textVerticalAlign_str = data.textVerticalAlign_str;
			props_obj.imageTransitionDirection_str = data.imageTransitionDirection_str;
			props_obj.thumbanilBoxShadow_str = data.thumbanilBoxShadow_str;
			props_obj.textAnimType_str = data.textAnimType_str;
			props_obj.disableThumbnails_bl = data.disableThumbnails_bl;
			props_obj.useIconButtons_bl = data.useIconButtons_bl;
			props_obj.alt_str = this.sourcePlaylist_ar[id].alt_str;
			props_obj.linkUrl_str = this.sourcePlaylist_ar[id].url;
			props_obj.linkTarget_str = this.sourcePlaylist_ar[id].target;
			props_obj.contentOffsetY = data.contentOffsetY;
			props_obj.buttonsOffest = data.buttonsOffestY;
			props_obj.isVerticalType_bl = data.isVerticalType_bl;
			
			
			props_obj.isDisabled_bl = this.sourcePlaylist_ar[id].disabled_bl;
			props_obj.htmlContent1_str = this.sourcePlaylist_ar[id].htmlContent1_str;
			props_obj.htmlContent2_str = this.sourcePlaylist_ar[id].htmlContent2_str;
			
			FWDVUGPThumbnail.setPrototype();
			thumbnail = new FWDVUGPThumbnail(props_obj);
			thumbnail.addListener(FWDVUGPThumbnail.MOUSE_UP, this.thumbanilOnMouseUpHandler);
			
			this.addChild(thumbnail);
			return thumbnail;
		};
		
		this.thumbanilOnMouseUpHandler = function(e){
			
			var regularId = e.id;
			var tempId = e.id;
			
			var type = e.extraButton ? "extraButtonLink" : self.sourcePlaylist_ar[regularId].type_str;
			
			for(var i=0; i<self.totalThumbnails; i++){
				if(i < tempId  && (self.sourcePlaylist_ar[i].type_str == FWDVUGP.NONE || self.sourcePlaylist_ar[i].type_str == FWDVUGP.LINK)){
					regularId -= 1;
				}
			};
			
			if(type == "extraButtonLink"){
				window.open(self.dataThumbnails_ar[e.id].thumbnail.extraButtonUrl_str, self.dataThumbnails_ar[e.id].thumbnail.extraButtonUrlTarget_str);
			}else if(type == "link"){
				window.open(self.dataThumbnails_ar[e.id].thumbnail.linkUrl_str, self.dataThumbnails_ar[e.id].thumbnail.linkTarget_str);
			}else{
				self.dispatchEvent(FWDVUGPVerticalThumbnailsManager.OPEN_LIGHTBOX, {id:regularId});
			}
			
		};
		
		//###############################################//
		/* Update category */
		//###############################################//
		this.updateCategory =  function(catId_ar){
			if(this.catId_ar == catId_ar) return;
			this.catId_ar = catId_ar;
			
			this.stopToLoadImage();
			this.filterCategories();
			this.positionThumbnailsAndMain();
			
			this.dispatchEvent(FWDVUGPVerticalThumbnailsManager.CATEGORY_UPDATE);
		};
		
		//###############################################//
		/* Load thumbnails */
		//###############################################//
		this.stopToLoadImage = function(){
			clearTimeout(this.loadThumbnailId_to);
			if (self.image_img){
				self.image_img.onerror = null;
				self.image_img.onload = null;
				//self.image_img.src = "";
			}
		};
		
		this.startToLoadImage = function(imagePath){
			self.image_img = new Image();
			self.image_img.onerror = self.onImageLoadErrorHandler;
			self.image_img.onload = self.onImageLoadHandler;
			self.image_img.src = imagePath;
		};
		
		this.loadThumbImage = function(){
			var dataThumbnail;
			var curLoadCatId;
			
			self.stopToLoadImage();
		
			for (var i=0; i<self.totalCats; i++){
				if(self.loadMoreCatsData_ar[i].isSelected && (self.loadMoreCatsData_ar[i].loaded < self.loadMoreCatsData_ar[i].limit)){
					curLoadCatId = i;
					break;
				}
			}
			
			for (var i=0; i<self.tempTotalThumbnails; i++){
				self.curDataThumbnail = self.tempPlaylist_ar[i];
				if (self.curDataThumbnail.catId == curLoadCatId && !self.curDataThumbnail.thumbnail) break;
			}
			
			self.startToLoadImage(self.sourcePlaylist_ar[self.curDataThumbnail.id].thumbnailPath_str);	
		};

		this.onImageLoadErrorHandler = function(e){
			var message = "Thumbnail image can't be loaded, probably the path is incorrect <font color='#FFFFFF'>"
					+ self.sourcePlaylist_ar[self.curDataThumbnail.id].thumbnailPath_str + "</font>";
			self.dispatchEvent(FWDVUGPVerticalThumbnailsManager.ERROR, {text : message});
		};

		this.onImageLoadHandler = function(e){
			
			var curThumbnail_do = self.getThumbnail(self.curDataThumbnail.catId, self.curDataThumbnail.id);
			
			self.loadMoreCatsData_ar[self.curDataThumbnail.catId].loaded++;
			
			self.curDataThumbnail.thumbnail = curThumbnail_do;
			curThumbnail_do.hasImg_bl = true;
			curThumbnail_do.originalWidth = self.image_img.width;
			curThumbnail_do.originalHeight = self.image_img.height;
			curThumbnail_do.addImage(self.image_img);
			
			self.countLoadedThumbs ++;
			if(!self.isFirstThumbnailLoaded_bl){
				setTimeout(function(){
					self.firstThumbnailShowed_bl = true;
				}, 200);
			}
			
			self.updateCurThumbnails();
			self.positionThumbnailsAndMain();
		};
		
		//###########################################//
		/* Update load more categories limits */
		//###########################################//
		this.updateCatsLimits = function(){
		
			var thumbsToAdd = self.thumbnailsPerSet;
			var catId = 0;
			
			if(this.showAllCategories_bl && this.catId_ar[0] == 0){
				if(this.loadMoreCatsData_ar[0].limit == 0){
					while((thumbsToAdd > 0) && (catId < this.totalCats)){
						if(this.loadMoreCatsData_ar[catId].limit + thumbsToAdd > this.loadMoreCatsData_ar[catId].total){
							thumbsToAdd -= this.loadMoreCatsData_ar[catId].total - this.loadMoreCatsData_ar[catId].limit;
							this.loadMoreCatsData_ar[catId].limit = this.loadMoreCatsData_ar[catId].total;
						}else{
							this.loadMoreCatsData_ar[catId].limit += thumbsToAdd;
							thumbsToAdd = 0;
						}
						
						catId++;
					}
				}
			}else{
				for (var i=0; i<this.totalCats; i++){
					if(this.loadMoreCatsData_ar[i].isSelected && this.loadMoreCatsData_ar[i].limit < this.thumbnailsPerSet){
						this.loadMoreCatsData_ar[i].limit = Math.min(this.loadMoreCatsData_ar[i].total, this.thumbnailsPerSet);
					}
				}
			}
			
			
			this.totalThumbnailsLimit = 0;
			
			for(var i=0; i<this.totalCats; i++){
				if (this.loadMoreCatsData_ar[i].isSelected){
					this.totalThumbnailsLimit += this.loadMoreCatsData_ar[i].limit;
				}
			}
		};
		
		//#################################################//
		/* Get allow to load more thumbnails */
		//#################################################//
		this.allowToLoadMoreThumbnails = function(){
			if((this.totalLoadedThumbnails == this.totalThumbnailsLimit) && (this.totalLoadedThumbnails < this.tempTotalThumbnails)){
				return true;
			}else{
				return false;
			}
		};
		
		
		//################################################//
		/* Load more thumbnails */
		//################################################//
		this.loadMore = function(){
			var thumbsToAdd = self.thumbnailsPerSet;
			var catId = 0;
			
			while((thumbsToAdd > 0) && (catId < self.totalCats)){
				if(self.loadMoreCatsData_ar[catId].isSelected){
					if(self.loadMoreCatsData_ar[catId].limit + thumbsToAdd > self.loadMoreCatsData_ar[catId].total){
						thumbsToAdd -= self.loadMoreCatsData_ar[catId].total - self.loadMoreCatsData_ar[catId].limit;
						self.loadMoreCatsData_ar[catId].limit = self.loadMoreCatsData_ar[catId].total;
					}else{
						self.loadMoreCatsData_ar[catId].limit += thumbsToAdd;
						thumbsToAdd = 0;
					}
				}
				
				catId++;
			}
		
			this.totalThumbnailsLimit = 0;
			
			for(var i=0; i<this.totalCats; i++){
				if (this.loadMoreCatsData_ar[i].isSelected){
					this.totalThumbnailsLimit += this.loadMoreCatsData_ar[i].limit;
				}
			}
			
			self.loadThumbImage();
		};
		
		//####################################//
		/* Filter categories */
		//###################################//
		this.filterCategories = function(){
		
			var dataThumbnail;
			var offsetCatId = 0;
			var hasCorrectId_bl;
			
			this.tempPlaylist_ar = [];
			this.playlist_ar = [];
			
			if(this.showAllCategories_bl) offsetCatId = 1;
			
			for(var i=0; i<this.totalCats; i++){
				this.loadMoreCatsData_ar[i].isSelected = false;
			}
			
			if(this.showAllCategories_bl && self.catId_ar[0] == 0){
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					this.tempPlaylist_ar.push(dataThumbnail);
					
					if (dataThumbnail.thumbnail){
						this.playlist_ar.push(dataThumbnail);
						dataThumbnail.thumbnail.show(true);
					}
				}
				
				for (var i=0; i<this.totalCats; i++){
					this.loadMoreCatsData_ar[i].isSelected = true;
				}
			}else{
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					hasCorrectId_bl = false;
					
					for (var j=0; j<this.totalCats; j++){
						if (dataThumbnail.catId == self.catId_ar[j] - offsetCatId){
							this.tempPlaylist_ar.push(dataThumbnail);
							
							if (dataThumbnail.thumbnail){
								this.playlist_ar.push(dataThumbnail);
							}
							
							this.loadMoreCatsData_ar[self.catId_ar[j] - offsetCatId].isSelected = true;
							
							hasCorrectId_bl = true;
						}
					}
					
					if(hasCorrectId_bl){
						if(dataThumbnail.thumbnail) dataThumbnail.thumbnail.show(true);
					}else{
						if(dataThumbnail.thumbnail) dataThumbnail.thumbnail.hide(true);
					}
				}

			}
			
			this.tempTotalThumbnails = this.tempPlaylist_ar.length;
			this.totalLoadedThumbnails = this.playlist_ar.length;
			
			this.updateCatsLimits();
			
			if(this.totalLoadedThumbnails < this.totalThumbnailsLimit){
				clearTimeout(this.loadThumbnailId_to);
				this.loadThumbnailId_to =  setTimeout(this.loadThumbImage, 300);
			}
			
			if(self.thumbnailLoadingType_str == "loadmorewithbutton"){ 
				this.hideOrShowLoadMoreButton();
			}
		};
		
		
		//######################################//
		/* Update thumbnails */
		//######################################//
		this.updateCurThumbnails = function(){
			var dataThumbnail;
			var offsetCatId = 0;
			
			this.playlist_ar = [];
			
			if(this.showAllCategories_bl) offsetCatId = 1;
			
			if (this.showAllCategories_bl && self.catId_ar[0] == 0){
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					
					if (dataThumbnail.thumbnail){
						this.playlist_ar.push(dataThumbnail);	
					}
				}
			}else{
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					
					for (var j=0; j<this.totalCats; j++){
						if (dataThumbnail.catId == self.catId_ar[j] - offsetCatId){
							if (dataThumbnail.thumbnail){
								this.playlist_ar.push(dataThumbnail);
							}
						}
					}
				}
			}
			
			this.totalLoadedThumbnails = this.playlist_ar.length;
			
			//console.log(this.totalLoadedThumbnails + " *** " + this.totalThumbnailsLimit + " @@@ " + this.tempTotalThumbnails);
			
			if (this.totalLoadedThumbnails < this.totalThumbnailsLimit){
				clearTimeout(this.loadThumbnailId_to);
				this.loadThumbnailId_to =  setTimeout(this.loadThumbImage, 10);
			}
			
			if(self.thumbnailLoadingType_str == "loadmorewithbutton"){ 
				this.hideOrShowLoadMoreButton();
			}else if(this.thumbnailLoadingType_str == "loadmoreonscroll"){
				this.loadInfinite();
			}
		};
		
		//###############################################//
		/* set data for thumbnail resize */
		//###############################################//
		this.setDataForResize = function(overwrite){
			if(!this.stageWidth) return;
			
			//if(this.stageWidth != this.prevStageWidth && !overwrite){
		
				this.totalColumns = Math.ceil((this.stageWidth) / (this.thumbnailMaxWidth + this.thumbsHSpace + this.borderSize * 2));
				
				this.thumbWidth = Math.floor((this.stageWidth - this.totalColumns * (this.thumbsHSpace + this.borderSize * 2)  - this.thumbsHOffset * 2) / this.totalColumns);
				this.thumbHeight = Math.floor(this.thumbWidth * (this.thumbnailMaxHeight / this.thumbnailMaxWidth));
				
				var totalWidth = this.totalColumns * (this.thumbWidth + this.thumbsHSpace + this.borderSize * 2) - this.thumbsHSpace;
				
				if(this.thumbsHOffset){
					this.thumbOffsetX = Math.floor((this.stageWidth - totalWidth) / 2);
				}else{
					this.leftWidth = this.stageWidth - totalWidth;
					this.thumbOffsetX = 0;
				}
				this.prevStageWidth = this.stageWidth;
			//}
		};
		
		//#############################################//
		/* Position and resize main thumbnails and main div's */
		//##############################################//
		this.positionThumbnailsAndMain = function(){
			
			this.columnHeights_ar = [];
			
			for (i=0; i<this.totalColumns; i++){
				this.columnHeights_ar[i] = 0;
			}
			
			for (i=0; i<this.totalLoadedThumbnails; i++){
				thumbnail = this.playlist_ar[i].thumbnail;
				thumbnail.used_bl = false;
			}
		
			// first positioning iteration
			this.positionThumbnails();
			
			// second positioning iteration - for any remaining thumbs that didn't fit the first time
			this.positionThumbnails();
			
			// last positioning iteration - for the last remaining high-width thumbs
			this.positionThumbnails2();
			
			this.totalHeight = Math.max(0, this.maxH * (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) - this.thumbsVSpace + this.thumbsVOffset * 2);
			this.positionLoadMoreButton();
			this.totalHeight += this.offsetTotalHeight;
			
			this.setWidth(this.stageWidth);
			
			if(this.prevTotalHeight != this.totalHeight){
				if(this.firstThumbnailShowed_bl && this.animateParent_bl && !this.isMobile_bl){
					FWDAnimation.to(this, .7, {h:this.totalHeight, ease:Quart.easeOut});
					clearTimeout(this.arangeFaterTweenId_to);
					this.arangeFaterTweenId_to = setTimeout(function(){
						if(self.stageWidth !=  parent.stageContainer.offsetWidth){
							parent.onResizeHandler();
						}
					}, 700);
					
				}else{
					this.setHeight(this.totalHeight);
				}
			}
			
			parent.setFinalSize();
			//setTimeout(parent.setFinalSize, 50);
			
			parent.stageWidth = parent.stageContainer.offsetWidth;
			this.prevTotalHeight = this.totalHeight;
			
			if(self.stageWidth != parent.stageWidth){
				parent.onResizeHandler();
			}
		};
		
		//###############################################//
		/* position thumbmails */
		//###############################################//
		this.positionThumbnails = function(){
			
			var i, j, k = 0;
			var minH;
			var addToLastThumbnail;
			var minHVal;
			var hSize;
			var wSize;
			var found_bl;
			var fPlace;
			var tempFinalX;
			var tempFinalY;
			var tempFinalW;
			var tempFinalH;
			var thumbnail;
			var addToThumbWidth_bl;
			
			this.maxH = 0;
			
			for (i=0; i<self.totalLoadedThumbnails; i++){
				//console.log(i)
				addToLastThumbnail = 0;
				addToThumbWidth_bl = false;
				thumbnail = self.playlist_ar[i].thumbnail;
				
				if(thumbnail.used_bl) continue;
				
				wSize = Math.round(thumbnail.originalWidth / self.thumbnailMaxWidth);
				//wSize = 1;
				
				if(wSize == 1) {
					thumbnail.used_bl = true;
					
					minHVal = 1000;
					
					for (j=0; j<self.totalColumns; j++){
						if(self.columnHeights_ar[j] < minHVal){
							minHVal = parseInt(self.columnHeights_ar[j]);
						}
					}
					
					for (j=0; j<self.totalColumns; j++){
						if (parseInt(self.columnHeights_ar[j]) == minHVal){
							minH = j;
							if(j == self.totalColumns - 1 && !self.thumbsHOffset) addToLastThumbnail = self.leftWidth;
							break;
						}
					}
					
					hSize = Math.round(thumbnail.originalHeight / self.thumbnailMaxHeight);
					
					tempFinalX = minH * (self.thumbWidth + self.thumbsHSpace + self.borderSize * 2) + self.thumbOffsetX;
					tempFinalY = self.columnHeights_ar[minH] * (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) + self.thumbsVOffset;
					
					tempFinalW = self.thumbWidth + self.borderSize * 2 + addToLastThumbnail;
					tempFinalH = (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) * hSize - self.thumbsVSpace;
					
					if ((thumbnail.finalX != tempFinalX) || (thumbnail.finalY != tempFinalY) || (thumbnail.finalW != tempFinalW) || (thumbnail.finalH != tempFinalH)
						 ||	thumbnail.isHidden_bl){
						
						thumbnail.finalW = tempFinalW;
						thumbnail.finalH = tempFinalH;
						
						thumbnail.finalX = tempFinalX;
						thumbnail.finalY = tempFinalY;
					
						thumbnail.resizeAndPosition();
					}
					
					self.columnHeights_ar[minH] += hSize;
					
				}else{
					minHVal = 150;
					
					addToLastThumbnail = 0;
					found_bl = false;
					
					for (j=0; j<self.totalColumns - (wSize-1); j++){
						
						fPlace = true;
						
						for (k=0; k<wSize; k++){
							if(self.columnHeights_ar[j] != self.columnHeights_ar[j+k])
								fPlace = false;
						}
						
						if (fPlace && (self.columnHeights_ar[j] < minHVal)){
							minHVal = self.columnHeights_ar[j];
							minH = j;
							if(j == self.totalColumns - wSize && !self.thumbsHOffset) addToLastThumbnail = self.leftWidth;
							found_bl = true;
						}
					}
					
					if (found_bl){
						
						var hSize = Math.round(thumbnail.originalHeight / self.thumbnailMaxHeight);
							
						thumbnail.used_bl = true;
						
						tempFinalX = minH * (self.thumbWidth + self.thumbsHSpace + self.borderSize * 2) + self.thumbOffsetX;
						tempFinalY = self.columnHeights_ar[minH] * (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) + self.thumbsVOffset;
						
						tempFinalW = (self.thumbWidth + self.thumbsHSpace + self.borderSize * 2) * wSize - self.thumbsHSpace +  addToLastThumbnail;
						tempFinalH = (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) * hSize - self.thumbsVSpace;
						
						if ((thumbnail.finalX != tempFinalX) || (thumbnail.finalY != tempFinalY) || (thumbnail.finalW != tempFinalW) || (thumbnail.finalH != tempFinalH)
							|| thumbnail.isHidden_bl){
							
							thumbnail.finalW = tempFinalW;
							thumbnail.finalH = tempFinalH;
							
							thumbnail.finalX = tempFinalX;
							thumbnail.finalY = tempFinalY;
							
							thumbnail.resizeAndPosition();
						}
						
						for (k=0; k<wSize; k++){
							self.columnHeights_ar[minH + k] += hSize;
						}
					}
				}
			}
		
			
			for (i=0; i<self.totalColumns; i++){
				if (self.columnHeights_ar[i] > self.maxH){
					self.maxH = self.columnHeights_ar[i];
				}
			}
		};
		
		//###############################################//
		/* position thumbnails at the bottom if they don't have a place in grid */
		//###############################################//
		this.positionThumbnails2 = function(){
			var i, j, k;
			var minH;
			var minHVal;
			var found;
			var fPlace;
			var addToLastThumbnail = 0;
			var tempFinalX;
			var tempFinalY;
			var tempFinalW;
			var tempFinalH;
			var addToThumbWidth_bl;
			
			this.maxH = 0;
			
			for (i=0; i<this.totalColumns; i++){
				if(this.columnHeights_ar[i] > this.maxH) this.maxH = this.columnHeights_ar[i];
			}
			
			for (i=0; i<this.totalLoadedThumbnails; i++){
				
				thumbnail = this.playlist_ar[i].thumbnail;
				
				if (thumbnail.used_bl) continue;
				
				thumbnail.used_bl = true;
			
				var wSize = Math.round(thumbnail.originalWidth / this.thumbnailMaxWidth);	
				var hSize = Math.round(thumbnail.originalHeight / this.thumbnailMaxHeight);
			
				if(this.totalColumns == wSize) addToLastThumbnail = this.leftWidth;
				
				if(this.totalColumns < wSize){
					wSize = this.totalColumns;
					hSize = this.totalColumns;
				}
				
				tempFinalX = this.thumbOffsetX;
				tempFinalY = this.maxH * (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) + this.thumbsVOffset;
				
				tempFinalW = (this.thumbWidth + this.thumbsHSpace + this.borderSize * 2) * wSize - this.thumbsHSpace +  addToLastThumbnail;
				tempFinalH = (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) * hSize - this.thumbsVSpace;
				
				if ((thumbnail.finalX != tempFinalX) || (thumbnail.finalY != tempFinalY) || (thumbnail.finalW != tempFinalW) || (thumbnail.finalH != tempFinalH)
					|| thumbnail.isHidden_bl){
					
					thumbnail.finalX = tempFinalX;
					thumbnail.finalY = tempFinalY;
					
					thumbnail.finalW = tempFinalW;
					thumbnail.finalH = tempFinalH;
					
					thumbnail.resizeAndPosition();
				}
				
				this.maxH += hSize;
				
				for (k=0; k<wSize; k++){
					this.columnHeights_ar[k] = this.maxH;
				}
			}
		};
		
		//##########################################//
		/* Setup load more button */
		//##########################################//
		this.setupLoadMoreButton = function(){
			
			FWDVUGPMenuButton.setPrototype();
			self.loadMoreButton_do = new FWDVUGPMenuButton(
				data.loadMoreButtonLabel_str,
				data.loadMoreButtonBackgroundNormalClassName_str,
				data.loadMoreButtonBackgroundSelectedClassName_str,
				data.loadMoreButtonTextNormalClassName_str,
				data.loadMoreButtonTextSeectedClassName_str
			);
			
			this.loadMoreButton_do.setLabel(data.loadMoreButtonLabel_str);
			this.loadMoreButton_do.getStyle().zIndex = 20;
			this.loadMoreButton_do.addListener(FWDVUGPMenuButton.MOUSE_UP, this.loadMoreButtonOnMouseUpHandler);
			this.hideLoadMoreButton();
			this.addChild(this.loadMoreButton_do);
		};
		
		this.loadMoreButtonOnMouseUpHandler = function(){
			self.hideLoadMoreButton();
			self.loadMore();
		};
		
		this.hideLoadMoreButton = function(){
			if(!this.loadMoreButton_do || !this.isLoadMoreButtonShowed_bl) return;
			this.isLoadMoreButtonShowed_bl = false;
			this.loadMoreButton_do.setVisible(false);
		};
		
		this.showLoadMoreButton = function(){
			if(!this.loadMoreButton_do || this.isLoadMoreButtonShowed_bl) return;
			this.isLoadMoreButtonShowed_bl = true;
			this.loadMoreButton_do.setVisible(true);
			if(!this.isMobile_bl){
				this.loadMoreButton_do.setAlpha(0);
				FWDAnimation.to(this.loadMoreButton_do, .6, {alpha:1});
			}
			this.positionLoadMoreButton();
		};
		
		this.hideOrShowLoadMoreButton = function(){
			if (self.allowToLoadMoreThumbnails()){
				self.showLoadMoreButton();
			}else{
				self.hideLoadMoreButton();
			}
		};
		
		this.positionLoadMoreButton = function(){
			if(!this.isLoadMoreButtonShowed_bl || !this.loadMoreButton_do){
				this.offsetTotalHeight = 0;
				return;
			}
			
			if(this.isMobile_bl || this.loadMoreButton_do.alpha == 0){
				this.loadMoreButton_do.setX(parseInt((this.stageWidth - this.loadMoreButton_do.w)/2));
				this.loadMoreButton_do.setY(this.totalHeight + this.loadMoreButtonOffsetTop);
			}else{
				FWDAnimation.to(this.loadMoreButton_do, .5, 
					{x:parseInt((this.stageWidth - this.loadMoreButton_do.w)/2),
					y:parseInt((this.totalHeight + this.loadMoreButtonOffsetTop))
				});
			}
			
			
			this.offsetTotalHeight = this.loadMoreButtonOffsetTop + this.loadMoreButtonOffsetBottom + this.loadMoreButton_do.h;
			
		};
		
		//######################################//
		/* Infinite scroll */
		//######################################//
		this.setupLoadMoreOnScroll = function(){
			if(window.addEventListener){
				window.addEventListener("scroll", this.onScrollHandler);
			}else if(window.attachEvent){
				window.attachEvent("onscroll", this.onScrollHandler);
			}
		};
		
		this.onScrollHandler = function(){
			self.loadInfinite();
			if(self.totalLoadedThumbnails == self.totalThumbnails){
				if(window.removeEventListener){
					window.removeEventListener("scroll", this.onScrollHandler);
				}else if(window.detachEvent){
					window.detachEvent("onscroll", this.onScrollHandler);
				}
			}
		};
		
		this.loadInfinite = function(){
			if(!this.allowToLoadMoreThumbnails()) return;
			var lastThumbnail = this.playlist_ar[this.playlist_ar.length - 1].thumbnail;
			clearTimeout(this.loadInifiniteId_to);
			this.loadInifiniteId_to = setTimeout(function(){
				if(lastThumbnail.getGlobalY() + lastThumbnail.finalH < FWDVRLUtils.getViewportSize().h){
					self.loadMore();
				}
			}, 500);
		};
		
		this.init();
	};
	
	/* set prototype */
	FWDVUGPVerticalThumbnailsManager.setPrototype = function(){
		FWDVUGPVerticalThumbnailsManager.prototype = new FWDVRLDisplayObject("div", "relative");
	};
	
	FWDVUGPVerticalThumbnailsManager.OPEN_LIGHTBOX = "openLightbox";
	FWDVUGPVerticalThumbnailsManager.CATEGORY_UPDATE = "categoryUpdate";
	FWDVUGPVerticalThumbnailsManager.ERROR = "error";
	
	FWDVUGPVerticalThumbnailsManager.prototype = null;
	window.FWDVUGPVerticalThumbnailsManager = FWDVUGPVerticalThumbnailsManager;
	
}(window));